/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.contention.MultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiThreadedRollingTest {
    static final int NUM_THREADS = 10;
    static final int TOTAL_DURATION = 600;
    RunnableWithCounterAndDone[] runnableArray;
    Encoder<Object> encoder;
    Context context = new ContextBase();
    static String VERIFY_SH = "verify.sh";
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/multi-" + this.diff + "/";
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    String pathToBash = EnvUtilForTests.getPathToBash();
    OutputStream scriptOS;

    @Before
    public void setUp() throws Exception {
        this.encoder = new EchoEncoder();
        File outputDir = new File(this.outputDirStr);
        outputDir.mkdirs();
        System.out.println("Output dir [" + this.outputDirStr + "]");
        this.scriptOS = this.openScript();
        this.rfa.setName("rolling");
        this.rfa.setEncoder(this.encoder);
        this.rfa.setContext(this.context);
        this.rfa.setFile(this.outputDirStr + "output.log");
    }

    void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        this.rfa.stop();
    }

    public void setUpTimeBasedTriggeringPolicy(RollingFileAppender<Object> rfa) {
        String datePattern = "yyyy-MM-dd'T'HH_mm_ss_SSS";
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern(this.outputDirStr + "test-%d{" + datePattern + "}");
        tbrp.setContext(this.context);
        tbrp.setParent(rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
    }

    public void setUpSizeBasedTriggeringPolicy(RollingFileAppender<Object> rfa) {
        SizeBasedTriggeringPolicy zbtp = new SizeBasedTriggeringPolicy();
        zbtp.setContext(this.context);
        zbtp.setMaxFileSize(FileSize.valueOf((String)"100KB"));
        zbtp.start();
        rfa.setTriggeringPolicy((TriggeringPolicy)zbtp);
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext(this.context);
        fwrp.setFileNamePattern(this.outputDirStr + "test-%i.log");
        fwrp.setMaxIndex(20);
        fwrp.setMinIndex(0);
        fwrp.setParent(rfa);
        fwrp.start();
        rfa.setRollingPolicy((RollingPolicy)fwrp);
        rfa.start();
    }

    RunnableWithCounterAndDone[] buildRunnableArray(boolean withDelay) {
        RunnableWithCounterAndDone[] runnableArray = new RunnableWithCounterAndDone[10];
        for (int i = 0; i < 10; ++i) {
            runnableArray[i] = new RFARunnable(i, this.rfa, withDelay);
        }
        return runnableArray;
    }

    OutputStream openScript() throws IOException {
        return new FileOutputStream(this.outputDirStr + VERIFY_SH);
    }

    @Test
    public void multiThreadedTimedBased() throws InterruptedException, IOException {
        this.setUpTimeBasedTriggeringPolicy(this.rfa);
        this.executeHarness(600, false);
        this.printScriptForTimeBased();
        this.verify();
    }

    int testFileCount() {
        File outputDir = new File(this.outputDirStr);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("test-\\d{1,2}.log");
            }
        };
        File[] files = outputDir.listFiles(filter);
        return files.length;
    }

    void verify() throws IOException, InterruptedException {
        this.close(this.scriptOS);
        if (this.pathToBash == null) {
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(this.pathToBash, VERIFY_SH);
        pb.directory(new File(this.outputDirStr));
        Process process = pb.start();
        process.waitFor();
        int exitCode = process.exitValue();
        Assert.assertEquals((long)8L, (long)exitCode);
        System.out.println("External script based verification returned with exit code " + exitCode);
    }

    @Test
    public void multiThreadedSizeBased() throws InterruptedException, IOException {
        this.setUpSizeBasedTriggeringPolicy(this.rfa);
        this.executeHarness(600, true);
        int numFiles = this.testFileCount();
        this.printScriptForSizeBased(numFiles);
        this.verify();
    }

    private void printScriptHeader(String type) throws IOException {
        this.out("# ====================================================");
        this.out("# A script to check the exactness of the output ");
        this.out("# produced by " + type + " test");
        this.out("# ====================================================");
        this.out("# ");
    }

    private void printCommonScriptCore() throws IOException {
        this.out("");
        this.out("for t in $(seq 0 1 9)");
        this.out("do");
        this.out("  echo \"Testing results of thread $t\"");
        this.out("  grep \"$t \" aggregated | cut -d ' ' -f 2 > ${t}-sample");
        this.out("  for j in $(seq 1 1 ${end[$t]}); do echo $j; done > ${t}-witness");
        this.out("  diff -q -w ${t}-sample ${t}-witness;");
        this.out("  res=$?");
        this.out("  if [ $res != \"0\" ]; then");
        this.out("    echo \"FAILED for $t\"");
        this.out("    exit 1");
        this.out("  fi");
        this.out("done");
        this.out("");
        this.out("exit 8");
    }

    private void printScriptForTimeBased() throws IOException {
        this.printScriptHeader("TimeBased");
        for (int i = 0; i < 10; ++i) {
            this.out("end[" + i + "]=" + this.runnableArray[i].getCounter());
        }
        this.out("");
        this.out("rm aggregated");
        this.out("cat test* output.log >> aggregated");
        this.printCommonScriptCore();
    }

    private void printScriptForSizeBased(int numfiles) throws IOException {
        this.printScriptHeader("SizeBased");
        for (int i = 0; i < 10; ++i) {
            this.out("end[" + i + "]=" + this.runnableArray[i].getCounter());
        }
        this.out("");
        this.out("rm aggregated");
        this.out("for i in $(seq " + (numfiles - 1) + " -1 0); do cat test-$i.log >> aggregated; done");
        this.out("cat output.log >> aggregated");
        this.out("");
        this.printCommonScriptCore();
    }

    private void out(String msg) throws IOException {
        this.scriptOS.write(msg.getBytes());
        this.scriptOS.write("\n".getBytes());
    }

    private void executeHarness(int duration, boolean withDelay) throws InterruptedException {
        MultiThreadedHarness multiThreadedHarness = new MultiThreadedHarness(duration);
        this.runnableArray = this.buildRunnableArray(withDelay);
        multiThreadedHarness.execute(this.runnableArray);
        StatusChecker checker = new StatusChecker(this.context.getStatusManager());
        if (!checker.isErrorFree(0L)) {
            StatusPrinter.print((Context)this.context);
            Assert.fail((String)"errors reported");
        }
    }

    long diff(long start) {
        return System.currentTimeMillis() - start;
    }

    static class RFARunnable
    extends RunnableWithCounterAndDone {
        RollingFileAppender<Object> rfa;
        int id;
        boolean withInducedDelay;

        RFARunnable(int id, RollingFileAppender<Object> rfa, boolean withInducedDelay) {
            this.id = id;
            this.rfa = rfa;
            this.withInducedDelay = withInducedDelay;
        }

        @Override
        public void run() {
            while (!this.isDone()) {
                ++this.counter;
                this.rfa.doAppend((Object)(this.id + " " + this.counter));
                if (this.counter % 64L != 0L || !this.withInducedDelay) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

