/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OptionHelperTest {
    String text = "Testing ${v1} variable substitution ${v2}";
    String expected = "Testing if variable substitution works";
    Context context = new ContextBase();
    Map<String, String> secondaryMap;

    @Before
    public void setUp() throws Exception {
        this.secondaryMap = new HashMap<String, String>();
    }

    @Test
    public void testLiteral() throws ScanException {
        String noSubst = "hello world";
        String result = OptionHelper.substVars((String)noSubst, (PropertyContainer)this.context);
        Assert.assertEquals((Object)noSubst, (Object)result);
    }

    @Test
    public void testUndefinedValues() throws ScanException {
        String withUndefinedValues = "${axyz}";
        String result = OptionHelper.substVars((String)withUndefinedValues, (PropertyContainer)this.context);
        Assert.assertEquals((Object)"axyz_IS_UNDEFINED", (Object)result);
    }

    @Test
    public void testSubstVarsVariableNotClosed() throws ScanException {
        String noSubst = "testing if ${v1 works";
        try {
            String result = OptionHelper.substVars((String)noSubst, (PropertyContainer)this.context);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSubstVarsContextOnly() throws ScanException {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
    }

    @Test
    public void testSubstVarsSystemProperties() throws ScanException {
        System.setProperty("v1", "if");
        System.setProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
        System.clearProperty("v1");
        System.clearProperty("v2");
    }

    @Test
    public void testSubstVarsWithDefault() throws ScanException {
        this.context.putProperty("v1", "if");
        String textWithDefault = "Testing ${v1} variable substitution ${v2:-toto}";
        String resultWithDefault = "Testing if variable substitution toto";
        String result = OptionHelper.substVars((String)textWithDefault, (PropertyContainer)this.context);
        Assert.assertEquals((Object)resultWithDefault, (Object)result);
    }

    @Test
    public void testSubstVarsRecursive() throws ScanException {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
    }

    @Test
    public void testSubstVarsTwoLevelsDeep() throws ScanException {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "${v4}");
        this.context.putProperty("v4", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
    }

    @Test
    public void testSubstVarsTwoLevelsWithDefault() throws ScanException {
        this.context.putProperty("APP_NAME", "LOGBACK");
        this.context.putProperty("ARCHIVE_SUFFIX", "archive.log");
        this.context.putProperty("LOG_HOME", "${logfilepath.default:-logs}");
        this.context.putProperty("ARCHIVE_PATH", "${LOG_HOME}/archive/${APP_NAME}");
        String result = OptionHelper.substVars((String)"${ARCHIVE_PATH}_trace_${ARCHIVE_SUFFIX}", (PropertyContainer)this.context);
        Assert.assertEquals((Object)"logs/archive/LOGBACK_trace_archive.log", (Object)result);
    }

    @Test(timeout=1000L)
    public void stubstVarsShouldNotGoIntoInfiniteLoop() throws ScanException {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "${v4}");
        this.context.putProperty("v4", "${v2}c");
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> OptionHelper.substVars((String)this.text, (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${v2} --> ${v3} --> ${v4} --> ${v2}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void nonCircularGraphShouldWork() throws ScanException {
        this.context.putProperty("A", "${B} and ${C}");
        this.context.putProperty("B", "${B1}");
        this.context.putProperty("B1", "B1-value");
        this.context.putProperty("C", "${C1} and ${B}");
        this.context.putProperty("C1", "C1-value");
        String result = OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
        Assert.assertEquals((Object)"B1-value and C1-value and B1-value", (Object)result);
    }

    @Test(timeout=1000L)
    public void detectCircularReferences0() throws ScanException {
        this.context.putProperty("A", "${A}");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${A} --> ${A}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test(timeout=1000L)
    public void detectCircularReferences1() throws ScanException {
        this.context.putProperty("A", "${A}a");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${A} --> ${A}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test(timeout=1000L)
    public void detectCircularReferences2() throws ScanException {
        this.context.putProperty("A", "${B}");
        this.context.putProperty("B", "${C}");
        this.context.putProperty("C", "${A}");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${A} --> ${B} --> ${C} --> ${A}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void recursionErrorWithNullLiteralPayload() throws ScanException {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"abc${AA$AA${}}}xyz", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${AA} --> ${}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void leftAccoladeFollowedByDefaultStateWithNoLiteral() throws ScanException {
        Exception e = (Exception)Assert.assertThrows(ScanException.class, () -> OptionHelper.substVars((String)"x{:-a}", (PropertyContainer)this.context));
        String expectedMessage = "Expecting at least a literal between left accolade and ':-'";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void nestedEmptyVariables() throws ScanException {
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> OptionHelper.substVars((String)"${${${}}}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${ ?  ? } --> ${ ? } --> ${}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void detectCircularReferencesInDefault() throws ScanException {
        this.context.putProperty("A", "${B:-${A}}");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${A} --> ${B} --> ${A}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test(timeout=1000L)
    public void detectCircularReferences3() throws ScanException {
        this.context.putProperty("A", "${B}");
        this.context.putProperty("B", "${C}");
        this.context.putProperty("C", "${A}");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${B} ", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${B} --> ${C} --> ${A} --> ${B}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test(timeout=1000L)
    public void detectCircularReferences4() throws ScanException {
        this.context.putProperty("A", "${B}");
        this.context.putProperty("B", "${C}");
        this.context.putProperty("C", "${A}");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${C} and ${A}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${C} --> ${A} --> ${B} --> ${C}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void detectCircularReferences5() throws ScanException {
        this.context.putProperty("A", "${B} and ${C}");
        this.context.putProperty("B", "${B1}");
        this.context.putProperty("B1", "B1-value");
        this.context.putProperty("C", "${C1}");
        this.context.putProperty("C1", "here's the loop: ${A}");
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context));
        String expectedMessage = "Circular variable reference detected while parsing input [${A} --> ${C} --> ${C1} --> ${A}]";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void defaultValueReferencingAVariable() throws ScanException {
        this.context.putProperty("v1", "k1");
        String result = OptionHelper.substVars((String)"${undef:-${v1}}", (PropertyContainer)this.context);
        Assert.assertEquals((Object)"k1", (Object)result);
    }

    @Test
    public void jackrabbit_standalone() throws ScanException {
        String r = OptionHelper.substVars((String)"${jackrabbit.log:-${repo:-jackrabbit}/log/jackrabbit.log}", (PropertyContainer)this.context);
        Assert.assertEquals((Object)"jackrabbit/log/jackrabbit.log", (Object)r);
    }

    @Test
    public void doesNotThrowNullPointerExceptionForEmptyVariable() throws JoranException, ScanException {
        this.context.putProperty("var", "");
        OptionHelper.substVars((String)"${var}", (PropertyContainer)this.context);
    }

    @Test
    public void openBraceAsLastCharacter() throws JoranException, ScanException {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> OptionHelper.substVars((String)"a{a{", (PropertyContainer)this.context));
        String expectedMessage = "All tokens consumed but was expecting \"}\"";
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void trailingColon_LOGBACK_1140() throws ScanException {
        String prefix = "c:";
        String suffix = "/tmp";
        this.context.putProperty("var", prefix);
        String r = OptionHelper.substVars((String)("${var}" + suffix), (PropertyContainer)this.context);
        Assert.assertEquals((Object)(prefix + suffix), (Object)r);
    }

    @Test
    public void curlyBraces_LOGBACK_1101() throws ScanException {
        String input = "foo{bar}";
        String r = OptionHelper.substVars((String)input, (PropertyContainer)this.context);
        Assert.assertEquals((Object)input, (Object)r);
        input = "{foo{\"bar\"}}";
        r = OptionHelper.substVars((String)input, (PropertyContainer)this.context);
        Assert.assertEquals((Object)input, (Object)r);
        input = "a:{y}";
        r = OptionHelper.substVars((String)input, (PropertyContainer)this.context);
        Assert.assertEquals((Object)input, (Object)r);
        input = "{world:{yay}}";
        r = OptionHelper.substVars((String)input, (PropertyContainer)this.context);
        Assert.assertEquals((Object)input, (Object)r);
        input = "{hello:{world:yay}}";
        r = OptionHelper.substVars((String)input, (PropertyContainer)this.context);
        Assert.assertEquals((Object)input, (Object)r);
        input = "{\"hello\":{\"world\":\"yay\"}}";
        r = OptionHelper.substVars((String)input, (PropertyContainer)this.context);
        Assert.assertEquals((Object)input, (Object)r);
    }
}

