/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class FileNamePatternTest {
    Context context = new ContextBase();

    @Test
    public void testSmoke() {
        FileNamePattern pp = new FileNamePattern("t", this.context);
        Assert.assertEquals((Object)"t", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo", this.context);
        Assert.assertEquals((Object)"foo", (Object)pp.convertInt(3));
        pp = new FileNamePattern("%i foo", this.context);
        Assert.assertEquals((Object)"3 foo", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo%i.xixo", this.context);
        Assert.assertEquals((Object)"foo3.xixo", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo%i.log", this.context);
        Assert.assertEquals((Object)"foo3.log", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo.%i.log", this.context);
        Assert.assertEquals((Object)"foo.3.log", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo.%3i.log", this.context);
        Assert.assertEquals((Object)"foo.003.log", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo.%1i.log", this.context);
        Assert.assertEquals((Object)"foo.43.log", (Object)pp.convertInt(43));
    }

    @Test
    public void flowingI() {
        FileNamePattern pp = new FileNamePattern("foo%i{}bar%i", this.context);
        Assert.assertEquals((Object)"foo3bar3", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo%i{}bar%i", this.context);
        Assert.assertEquals((Object)"foo3bar3", (Object)pp.convertInt(3));
    }

    @Test
    public void date() {
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 4, 20, 17, 55);
        FileNamePattern pp = new FileNamePattern("foo%d{yyyy.MM.dd}", this.context);
        Assert.assertEquals((Object)"foo2003.05.20", (Object)pp.convert((Object)cal.getTime()));
        pp = new FileNamePattern("foo%d{yyyy.MM.dd HH:mm}", this.context);
        Assert.assertEquals((Object)"foo2003.05.20 17:55", (Object)pp.convert((Object)cal.getTime()));
        pp = new FileNamePattern("%d{yyyy.MM.dd HH:mm} foo", this.context);
        Assert.assertEquals((Object)"2003.05.20 17:55 foo", (Object)pp.convert((Object)cal.getTime()));
    }

    @Test
    public void dateWithTimeZone() {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(utc);
        cal.set(2003, 4, 20, 10, 55);
        FileNamePattern fnp = new FileNamePattern("foo%d{yyyy-MM-dd'T'HH:mm, Australia/Perth}", this.context);
        Assert.assertEquals((Object)"foo2003-05-20T18:55", (Object)fnp.convert((Object)cal.getTime()));
    }

    @Test
    public void auxAndTimeZoneShouldNotConflict() {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(utc);
        cal.set(2003, 4, 20, 10, 55);
        FileNamePattern fnp = new FileNamePattern("foo%d{yyyy-MM-dd'T'HH:mm, aux, Australia/Perth}", this.context);
        Assert.assertEquals((Object)"foo2003-05-20T18:55", (Object)fnp.convert((Object)cal.getTime()));
        Assert.assertNull((Object)fnp.getPrimaryDateTokenConverter());
        fnp = new FileNamePattern("folder/%d{yyyy/MM, aux, Australia/Perth}/test.%d{yyyy-MM-dd'T'HHmm, Australia/Perth}.log", this.context);
        Assert.assertEquals((Object)"folder/2003/05/test.2003-05-20T1855.log", (Object)fnp.convert((Object)cal.getTime()));
        Assert.assertNotNull((Object)fnp.getPrimaryDateTokenConverter());
    }

    @Test
    public void withBackslash() {
        FileNamePattern pp = new FileNamePattern("c:\\foo\\bar.%i", this.context);
        Assert.assertEquals((Object)"c:/foo/bar.3", (Object)pp.convertInt(3));
    }

    @Test
    public void objectListConverter() {
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 4, 20, 17, 55);
        FileNamePattern fnp = new FileNamePattern("foo-%d{yyyy.MM.dd}-%i.txt", this.context);
        Assert.assertEquals((Object)"foo-2003.05.20-79.txt", (Object)fnp.convertMultipleArguments(new Object[]{cal.getTime(), 79}));
    }

    @Test
    public void asRegexByDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 4, 20, 17, 55);
        FileNamePattern fnp = new FileNamePattern("foo-%d{yyyy.MM.dd}-%i.txt", this.context);
        String regex = fnp.toRegexForFixedDate(cal.getTime());
        Assert.assertEquals((Object)"foo-2003.05.20-(\\d+).txt", (Object)regex);
        fnp = new FileNamePattern("\\toto\\foo-%d{yyyy\\MM\\dd}-%i.txt", this.context);
        regex = fnp.toRegexForFixedDate(cal.getTime());
        Assert.assertEquals((Object)"/toto/foo-2003/05/20-(\\d+).txt", (Object)regex);
    }

    @Test
    public void asRegex() {
        FileNamePattern fnp = new FileNamePattern("foo-%d{yyyy.MM.dd}-%i.txt", this.context);
        String regex = fnp.toRegex();
        Assert.assertEquals((Object)"foo-\\d{4}\\.\\d{2}\\.\\d{2}-\\d+.txt", (Object)regex);
        fnp = new FileNamePattern("foo-%d{yyyy.MM.dd'T'}-%i.txt", this.context);
        regex = fnp.toRegex();
        Assert.assertEquals((Object)"foo-\\d{4}\\.\\d{2}\\.\\d{2}T-\\d+.txt", (Object)regex);
    }

    @Test
    public void convertMultipleDates() {
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 4, 20, 17, 55);
        FileNamePattern fnp = new FileNamePattern("foo-%d{yyyy.MM, aux}/%d{yyyy.MM.dd}.txt", this.context);
        Assert.assertEquals((Object)"foo-2003.05/2003.05.20.txt", (Object)fnp.convert((Object)cal.getTime()));
    }

    @Test
    public void nullTimeZoneByDefault() {
        FileNamePattern fnp = new FileNamePattern("%d{hh}", this.context);
        Assert.assertNull((Object)fnp.getPrimaryDateTokenConverter().getZoneId());
    }

    @Test
    public void settingTimeZoneOptionHasAnEffect() {
        ZoneId tz = ZoneId.of("Australia/Perth");
        FileNamePattern fnp = new FileNamePattern("%d{hh, " + tz.getId() + "}", this.context);
        Assert.assertEquals((Object)tz, (Object)fnp.getPrimaryDateTokenConverter().getZoneId());
    }
}

