/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.DefaultRolloverChecker;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverChecker;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.ZRolloverChecker;
import ch.qos.logback.core.rolling.testUtil.ScaffoldingForRollingTests;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimeBasedRollingTest
extends ScaffoldingForRollingTests {
    static final int NO_RESTART = 0;
    static final int WITH_RESTART = 1;
    static final int WITH_RESTART_AND_LONG_WAIT = 2000;
    static final boolean FILE_OPTION_SET = true;
    static final boolean FILE_OPTION_BLANK = false;
    RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp1 = new TimeBasedRollingPolicy();
    RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp2 = new TimeBasedRollingPolicy();
    EchoEncoder<Object> encoder = new EchoEncoder();
    RolloverChecker rolloverChecker;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @AfterEach
    public void tearDown() {
    }

    void initRFA(RollingFileAppender<Object> rfa, String filename) {
        rfa.setContext(this.context);
        rfa.setEncoder(this.encoder);
        if (filename != null) {
            rfa.setFile(filename);
        }
    }

    void initTRBP(RollingFileAppender<Object> rfa, TimeBasedRollingPolicy<Object> tbrp, String filenamePattern, long givenTime) {
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern(filenamePattern);
        tbrp.setParent(rfa);
        tbrp.timeBasedFileNamingAndTriggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(givenTime);
        rfa.setRollingPolicy(tbrp);
        tbrp.start();
        rfa.start();
    }

    void genericTest(String testId, String patternPrefix, String compressionSuffix, UnaryOperator<String> filenameFunction, int waitDuration) throws IOException {
        String fileName = (String)filenameFunction.apply(testId);
        this.initRFA(this.rfa1, fileName);
        String fileNamePatternStr = this.randomOutputDir + patternPrefix + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}" + compressionSuffix;
        this.initTRBP(this.rfa1, this.tbrp1, fileNamePatternStr, this.currentTime);
        this.addExpectedFileName_ByDate(fileNamePatternStr, this.getMillisOfCurrentPeriodsStart());
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
        for (int i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(fileNamePatternStr);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            this.add(this.tbrp1.compressionFuture);
            this.add(this.tbrp1.cleanUpFuture);
        }
        this.rfa1.stop();
        this.waitForJobsToComplete();
        if (waitDuration != 0) {
            this.doRestart(testId, patternPrefix, filenameFunction, waitDuration);
        }
        this.waitForJobsToComplete();
        this.massageExpectedFilesToCorresponToCurrentTarget(testId, filenameFunction);
        this.rolloverChecker.check(this.expectedFilenameList);
    }

    void defaultTest(String testId, String patternPrefix, String compressionSuffix, UnaryOperator<String> filenameFunction, int waitDuration) throws IOException {
        boolean withCompression = compressionSuffix.length() > 0;
        this.rolloverChecker = new DefaultRolloverChecker(testId, withCompression, compressionSuffix);
        this.genericTest(testId, patternPrefix, compressionSuffix, filenameFunction, waitDuration);
    }

    void doRestart(String testId, String patternPart, UnaryOperator<String> filenameFunction, int waitDuration) {
        File activeFile = new File(this.rfa1.getFile());
        activeFile.setLastModified(this.currentTime);
        this.incCurrentTime(waitDuration);
        String filePatternStr = this.randomOutputDir + patternPart + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}";
        String fileName = (String)filenameFunction.apply(testId);
        this.initRFA(this.rfa2, fileName);
        this.initTRBP(this.rfa2, this.tbrp2, filePatternStr, this.currentTime);
        for (int i = 0; i < 3; ++i) {
            this.rfa2.doAppend((Object)("World---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(filePatternStr);
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            this.add(this.tbrp2.compressionFuture);
            this.add(this.tbrp1.cleanUpFuture);
        }
        this.rfa2.stop();
    }

    @Test
    public void noCompression_FileBlank_NoRestart_1() throws IOException {
        this.defaultTest("test1", "test1", "", x$0 -> this.nullFileName((String)x$0), 0);
    }

    @Test
    public void withCompression_FileBlank_NoRestart_2() throws IOException {
        this.defaultTest("test2", "test2", ".gz", x$0 -> this.nullFileName((String)x$0), 0);
    }

    @Test
    public void noCompression_FileBlank_StopRestart_3() throws IOException {
        this.defaultTest("test3", "test3", "", x$0 -> this.nullFileName((String)x$0), 1);
    }

    @Test
    public void noCompression_FileSet_StopRestart_4() throws IOException {
        this.defaultTest("test4", "test4", "", x$0 -> this.testId2FileName((String)x$0), 1);
    }

    @Test
    public void noCompression_FileSet_StopRestart_WithLongWait_4B() throws IOException {
        this.defaultTest("test4B", "test4B", "", x$0 -> this.testId2FileName((String)x$0), 2000);
    }

    @Test
    public void noCompression_FileSet_NoRestart_5() throws IOException {
        this.defaultTest("test5", "test5", "", x$0 -> this.testId2FileName((String)x$0), 0);
    }

    @Test
    public void withCompression_FileSet_NoRestart_6() throws IOException {
        this.defaultTest("test6", "test6", ".gz", x$0 -> this.testId2FileName((String)x$0), 0);
    }

    @Test
    public void withMissingTargetDirWithCompression() throws IOException {
        this.defaultTest("test7", "%d{yyyy-MM-dd, aux}/test7", ".gz", x$0 -> this.testId2FileName((String)x$0), 0);
    }

    @Test
    public void withMissingTargetDirWithZipCompression() throws IOException {
        this.defaultTest("test8", "%d{yyyy-MM-dd, aux}/test8", ".zip", x$0 -> this.testId2FileName((String)x$0), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failed_rename() throws IOException {
        if (!EnvUtilForTests.isWindows()) {
            return;
        }
        String testId = "failed_rename";
        FileOutputStream fos = null;
        try {
            String fileName = this.testId2FileName(testId);
            File file = new File(fileName);
            file.getParentFile().mkdirs();
            fos = new FileOutputStream(fileName);
            this.rolloverChecker = new ZRolloverChecker(testId);
            this.genericTest(testId, "failed_rename", "", x$0 -> this.testId2FileName((String)x$0), 0);
            this.rolloverChecker.check(this.expectedFilenameList);
        }
        finally {
            StatusPrinter.print((Context)this.context);
            if (fos != null) {
                fos.close();
            }
        }
    }
}

