/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationTest {
    static long HOURS_CO = 3600L;
    static long DAYS_CO = 86400L;

    @Test
    public void test() {
        Duration d = Duration.valueOf((String)"12");
        Assertions.assertEquals((long)12L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"159 milli");
        Assertions.assertEquals((long)159L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"15 millis");
        Assertions.assertEquals((long)15L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"8 milliseconds");
        Assertions.assertEquals((long)8L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10.7 millisecond");
        Assertions.assertEquals((long)10L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10 SECOnds");
        Assertions.assertEquals((long)10000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"12seconde");
        Assertions.assertEquals((long)12000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"14 SECONDES");
        Assertions.assertEquals((long)14000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"12second");
        Assertions.assertEquals((long)12000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10.7 seconds");
        Assertions.assertEquals((long)10700L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"1 minute");
        Assertions.assertEquals((long)60000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"2.2 minutes");
        Assertions.assertEquals((long)132000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"1 hour");
        Assertions.assertEquals((long)(1000L * HOURS_CO), (long)d.getMilliseconds());
        d = Duration.valueOf((String)"4.2 hours");
        Assertions.assertEquals((long)(4200L * HOURS_CO), (long)d.getMilliseconds());
        d = Duration.valueOf((String)"5 days");
        Assertions.assertEquals((long)(5000L * DAYS_CO), (long)d.getMilliseconds());
    }
}

