/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.EnvUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

public class EnvUtilTest {
    @Mock
    private String savedVersion = System.getProperty("java.version");

    @AfterEach
    public void tearDown() {
        System.setProperty("java.version", this.savedVersion);
    }

    @Test
    public void jdkVersion() {
        Assertions.assertEquals((int)4, (int)EnvUtil.getJDKVersion((String)"1.4.xx"));
        Assertions.assertEquals((int)5, (int)EnvUtil.getJDKVersion((String)"1.5"));
        Assertions.assertEquals((int)5, (int)EnvUtil.getJDKVersion((String)"1.5.xx"));
        Assertions.assertEquals((int)5, (int)EnvUtil.getJDKVersion((String)"1.5AA"));
        Assertions.assertEquals((int)9, (int)EnvUtil.getJDKVersion((String)"9EA"));
        Assertions.assertEquals((int)9, (int)EnvUtil.getJDKVersion((String)"9.0.1"));
        Assertions.assertEquals((int)18, (int)EnvUtil.getJDKVersion((String)"18.3+xx"));
    }

    @Test
    public void testJava1_4() {
        System.setProperty("java.version", "1.4.xx");
        Assertions.assertFalse((boolean)EnvUtil.isJDK5());
        Assertions.assertFalse((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_5() {
        System.setProperty("java.version", "1.5");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertFalse((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_5_x() {
        System.setProperty("java.version", "1.5.xx");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertFalse((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_6() {
        System.setProperty("java.version", "1.6.xx");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_7() {
        System.setProperty("java.version", "1.7.xx");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_8() {
        System.setProperty("java.version", "1.8.xx");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava9() {
        System.setProperty("java.version", "9");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava9_1() {
        System.setProperty("java.version", "9.xx");
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava18_3() {
        System.setProperty("java.version", "18.3+xx");
        Assertions.assertEquals((int)18, (int)EnvUtil.getJDKVersion((String)"18.3+xx"));
        Assertions.assertTrue((boolean)EnvUtil.isJDK5());
        Assertions.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assertions.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }
}

