/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.ComponentTracker;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.spi.CyclicBufferTrackerT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class CyclicBufferTrackerSimulator {
    CyclicBufferTracker<Object> realCBTracker = new CyclicBufferTracker();
    CyclicBufferTrackerT<Object> t_CBTracker = new CyclicBufferTrackerT();
    List<SimulationEvent> scenario = new ArrayList<SimulationEvent>();
    List<String> keySpace = new ArrayList<String>();
    Random randomKeyGen = new Random(100L);
    Random simulatorRandom = new Random(11234L);
    Parameters params;
    int getToEndOfLifeRatio = 10;

    CyclicBufferTrackerSimulator(Parameters params) {
        this.params = params;
        HashMap<String, String> checkMap = new HashMap<String, String>();
        for (int i = 0; i < params.keySpaceLen; ++i) {
            String k = this.getRandomKeyStr();
            if (checkMap.containsKey(k)) {
                System.out.println("random key collision occurred");
                k = k + "" + i;
            }
            this.keySpace.add(k);
            checkMap.put(k, k);
        }
    }

    private String getRandomKeyStr() {
        int ri = this.randomKeyGen.nextInt();
        return String.format("%X", ri);
    }

    void buildScenario() {
        long timestamp = 30000L;
        int keySpaceLen = this.keySpace.size();
        for (int i = 0; i < this.params.simulationLength; ++i) {
            int keyIndex = this.simulatorRandom.nextInt(keySpaceLen);
            String key = this.keySpace.get(keyIndex);
            this.scenario.add(new SimulationEvent(EventType.INSERT, key, timestamp += (long)this.simulatorRandom.nextInt(this.params.maxTimestampInc)));
            if (this.simulatorRandom.nextInt(this.getToEndOfLifeRatio) == 0) {
                this.scenario.add(new SimulationEvent(EventType.END_OF_LIFE, key, timestamp));
            }
            this.scenario.add(new SimulationEvent(EventType.REMOVE_STALE, key, timestamp));
        }
    }

    public void dump() {
        for (SimulationEvent simeEvent : this.scenario) {
            System.out.println(simeEvent);
        }
    }

    void play(SimulationEvent simulationEvent, ComponentTracker<CyclicBuffer<Object>> tracker) {
        String key = simulationEvent.key;
        long timestamp = simulationEvent.timestamp;
        EventType eventType = simulationEvent.eventType;
        switch (eventType.ordinal()) {
            case 0: {
                tracker.getOrCreate(key, timestamp);
                break;
            }
            case 1: {
                tracker.endOfLife(key);
                break;
            }
            case 2: {
                tracker.removeStaleComponents(timestamp);
            }
        }
    }

    public void simulate() {
        for (SimulationEvent simeEvent : this.scenario) {
            this.play(simeEvent, (ComponentTracker<CyclicBuffer<Object>>)this.realCBTracker);
            this.play(simeEvent, this.t_CBTracker);
        }
    }

    static class Parameters {
        public int keySpaceLen;
        public int maxTimestampInc;
        public int simulationLength;

        Parameters() {
        }
    }

    class SimulationEvent {
        public final String key;
        public final long timestamp;
        final EventType eventType;

        public SimulationEvent(EventType eventType, String key, long timestamp) {
            this.eventType = eventType;
            this.key = key;
            this.timestamp = timestamp;
        }

        public String toString() {
            return "SimulationEvent{eventType=" + (Object)((Object)this.eventType) + ", key='" + this.key + '\'' + ", timestamp=" + this.timestamp + '}';
        }
    }

    static enum EventType {
        INSERT,
        END_OF_LIFE,
        REMOVE_STALE;

    }
}

