/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RollingCalendarTest {
    String dailyPattern = "yyyy-MM-dd";
    final long WED_2016_03_23_T_230705_CET = 1458770825333L;

    @BeforeEach
    public void setUp() {
        Locale oldLocale = Locale.getDefault();
        Locale.setDefault(oldLocale);
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testPeriodicity() {
        RollingCalendar rc = new RollingCalendar("yyyy-MM-dd_HH_mm_ss");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_SECOND, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd_HH_mm");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_MINUTE, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd_HH");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_HOUR, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd_hh");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_HOUR, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_DAY, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_MONTH, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-ww");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_WEEK, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-W");
        Assertions.assertEquals((Object)PeriodicityType.TOP_OF_WEEK, (Object)rc.getPeriodicityType());
    }

    @Test
    public void testVaryingNumberOfHourlyPeriods() {
        RollingCalendar rc = new RollingCalendar("yyyy-MM-dd_HH");
        long MILLIS_IN_HOUR = 3600000L;
        for (int p = 100; p > -100; --p) {
            long now = 1223325293589L;
            Instant result = rc.getEndOfNextNthPeriod(Instant.ofEpochMilli(now), p);
            long expected = now - now % MILLIS_IN_HOUR + (long)p * MILLIS_IN_HOUR;
            Assertions.assertEquals((long)expected, (long)result.toEpochMilli());
        }
    }

    @Test
    public void testVaryingNumberOfDailyPeriods() {
        RollingCalendar rc = new RollingCalendar("yyyy-MM-dd");
        long MILLIS_IN_DAY = 86400000L;
        for (int p = 20; p > -100; --p) {
            long now = 1223325293589L;
            Instant nowInstant = Instant.ofEpochMilli(now);
            Instant result = rc.getEndOfNextNthPeriod(nowInstant, p);
            long offset = rc.getTimeZone().getRawOffset() + rc.getTimeZone().getDSTSavings();
            long origin = now - (now + offset) % 86400000L;
            long expected = origin + (long)p * 86400000L;
            Assertions.assertEquals((long)expected, (long)result.toEpochMilli(), (String)("p=" + p));
        }
    }

    @Test
    public void testBarrierCrossingComputation() {
        this.checkPeriodBarriersCrossed("yyyy-MM-dd'T'HHmmss", 1458770825333L, 1458770828333L, 3);
        this.checkPeriodBarriersCrossed("yyyy-MM-dd'T'HHmm", 1458770825333L, 1458771005333L, 3);
        this.checkPeriodBarriersCrossed("yyyy-MM-dd'T'HH", 1458770825333L, 1458781625333L, 3);
        this.checkPeriodBarriersCrossed("yyyy-MM-dd", 1458770825333L, 1459030025333L, 3);
    }

    private void checkPeriodBarriersCrossed(String pattern, long start, long end, int count) {
        RollingCalendar rc = new RollingCalendar(pattern);
        Assertions.assertEquals((long)count, (long)rc.periodBarriersCrossed(start, end));
    }

    @Test
    public void testCollisionFreenes() {
        this.checkCollisionFreeness("yyyy-MM-dd hh", false);
        this.checkCollisionFreeness("yyyy-MM-dd hh a", true);
        this.checkCollisionFreeness("yyyy-MM-dd HH", true);
        this.checkCollisionFreeness("yyyy-MM-dd kk", true);
        this.checkCollisionFreeness("yyyy-MM-dd KK", false);
        this.checkCollisionFreeness("yyyy-MM-dd KK a", true);
        this.checkCollisionFreeness("yyyy-MM-dd", true);
        this.checkCollisionFreeness("yyyy-dd", false);
        this.checkCollisionFreeness("dd", false);
        this.checkCollisionFreeness("MM-dd", false);
        this.checkCollisionFreeness("yyyy-DDD", true);
        this.checkCollisionFreeness("DDD", false);
        this.checkCollisionFreeness("yyyy-MM-W", true);
        this.dumpCurrentLocale(Locale.getDefault());
        this.checkCollisionFreeness("yyyy-W", false);
        this.checkCollisionFreeness("yyyy-ww", true);
    }

    private void dumpCurrentLocale(Locale locale) {
        System.out.println("***Current default locale is " + locale);
    }

    private void checkCollisionFreeness(String pattern, boolean expected) {
        RollingCalendar rc = new RollingCalendar(pattern);
        if (expected) {
            Assertions.assertTrue((boolean)rc.isCollisionFree());
        } else {
            Assertions.assertFalse((boolean)rc.isCollisionFree());
        }
    }

    @Test
    public void basicPeriodBarriersCrossed() {
        RollingCalendar rc = new RollingCalendar(this.dailyPattern, TimeZone.getTimeZone("CET"), Locale.US);
        long start = 1485456418969L;
        long end = start + 86400000L;
        Assertions.assertEquals((long)1L, (long)rc.periodBarriersCrossed(start, end));
    }

    @Test
    public void testPeriodBarriersCrossedWhenGoingIntoDaylightSaving() {
        RollingCalendar rc = new RollingCalendar(this.dailyPattern, TimeZone.getTimeZone("CET"), Locale.US);
        long start = 1490482923333L;
        long end = 1490565723333L;
        Assertions.assertEquals((long)1L, (long)rc.periodBarriersCrossed(start, end));
    }

    @Test
    public void testPeriodBarriersCrossedWhenLeavingDaylightSaving() {
        RollingCalendar rc = new RollingCalendar(this.dailyPattern, TimeZone.getTimeZone("CET"), Locale.US);
        long start = 1509228123333L;
        long end = 1509318123333L;
        Assertions.assertEquals((long)1L, (long)rc.periodBarriersCrossed(start, end));
    }

    @Test
    public void testPeriodBarriersCrossedJustBeforeEnteringDaylightSaving() {
        RollingCalendar rc = new RollingCalendar(this.dailyPattern, TimeZone.getTimeZone("CET"), Locale.US);
        long start = 1490559518333L;
        System.out.println(new Date(start));
        long end = 1490565918333L;
        System.out.println(new Date(end));
        Assertions.assertEquals((long)1L, (long)rc.periodBarriersCrossed(start, end));
    }
}

