/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.sanity;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.sanity.AppenderWithinAppenderSanityChecker;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.TopModel;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AppenderWithinAppenderSanityCheckerTest {
    Context context = new ContextBase();
    AppenderWithinAppenderSanityChecker awasc = new AppenderWithinAppenderSanityChecker();
    StatusChecker statusChecker = new StatusChecker(this.context);

    @BeforeEach
    public void setUp() throws Exception {
        this.awasc.setContext(this.context);
    }

    @Test
    public void smoke() {
        TopModel topModel = new TopModel();
        this.awasc.check((Model)topModel);
        this.statusChecker.assertIsWarningOrErrorFree();
    }

    @Test
    public void singleAppender() {
        TopModel topModel = new TopModel();
        AppenderModel appenderModel0 = new AppenderModel();
        appenderModel0.setLineNumber(1);
        topModel.addSubModel((Model)appenderModel0);
        this.awasc.check((Model)topModel);
        this.statusChecker.assertIsWarningOrErrorFree();
    }

    @Test
    public void nestedAppender() {
        TopModel topModel = new TopModel();
        AppenderModel appenderModel0 = new AppenderModel();
        appenderModel0.setLineNumber(1);
        topModel.addSubModel((Model)appenderModel0);
        AppenderModel appenderModel1 = new AppenderModel();
        appenderModel1.setLineNumber(2);
        appenderModel0.addSubModel((Model)appenderModel1);
        this.awasc.check((Model)topModel);
        this.statusChecker.assertContainsMatch(1, AppenderWithinAppenderSanityChecker.NESTED_APPENDERS_WARNING);
        this.statusChecker.assertContainsMatch(1, "Appender at line 1");
    }
}

