/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.Attributes;

public class SaxEventRecorderTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);

    SAXParser createParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser();
    }

    public List<SaxEvent> doTest(String filename) throws Exception {
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        FileInputStream fis = new FileInputStream("src/test/input/joran/" + filename);
        recorder.recordEvents((InputStream)fis);
        return recorder.getSaxEventList();
    }

    public void dump(List<SaxEvent> seList) {
        for (SaxEvent se : seList) {
            System.out.println(se);
        }
    }

    @Test
    public void test1() throws Exception {
        List<SaxEvent> seList = this.doTest("event1.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)11, (int)seList.size());
    }

    @Test
    public void test2() throws Exception {
        List<SaxEvent> seList = this.doTest("ampEvent.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assertions.assertEquals((Object)"xxx & yyy", (Object)be.getText());
    }

    @Test
    public void test3() throws Exception {
        List<SaxEvent> seList = this.doTest("inc.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)seList.size());
        StartEvent se = (StartEvent)seList.get(1);
        Attributes attr = se.getAttributes();
        Assertions.assertNotNull((Object)attr);
        Assertions.assertEquals((Object)"1", (Object)attr.getValue("increment"));
    }

    @Test
    public void bodyWithSpacesAndQuotes() throws Exception {
        List<SaxEvent> seList = this.doTest("spacesAndQuotes.xml");
        Assertions.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assertions.assertEquals((Object)"[x][x] \"xyz\"%n", (Object)be.getText());
    }
}

