/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrudentFileAppenderInterruptTest {
    FileAppender<Object> fa = new FileAppender();
    Context context = new ContextBase();
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/resilience-" + this.diff + "/";
    String logfileStr = this.outputDirStr + "output.log";

    @BeforeEach
    public void setUp() throws InterruptedException {
        this.context.getStatusManager().add((StatusListener)new OnConsoleStatusListener());
        File outputDir = new File(this.outputDirStr);
        outputDir.mkdirs();
        this.fa.setContext(this.context);
        this.fa.setName("FILE");
        this.fa.setPrudent(true);
        this.fa.setEncoder((Encoder)new EchoEncoder());
        this.fa.setFile(this.logfileStr);
        this.fa.start();
    }

    @Test
    public void smoke() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread t = new Thread(runner);
        t.start();
        runner.latch.await();
        this.fa.doAppend((Object)"hello not interrupted");
        FileReader fr = new FileReader(this.logfileStr);
        BufferedReader br = new BufferedReader(fr);
        int totalLines = 0;
        while (br.readLine() != null) {
            ++totalLines;
        }
        fr.close();
        br.close();
        Assertions.assertEquals((int)2, (int)totalLines, (String)"Incorrect number of logged lines");
    }

    class Runner
    extends RunnableWithCounterAndDone {
        FileAppender<Object> fa;
        CountDownLatch latch = new CountDownLatch(1);

        Runner(FileAppender<Object> fa) {
            this.fa = fa;
        }

        @Override
        public void run() {
            Thread.currentThread().interrupt();
            this.fa.doAppend((Object)"hello interrupted");
            this.latch.countDown();
        }
    }
}

