/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.appender.XTeeOutputStream;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fusesource.jansi.AnsiPrintStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConsoleAppenderTest
extends AbstractAppenderTest<Object> {
    XTeeOutputStream teeOut;
    XTeeOutputStream teeErr;
    PrintStream originalOut;
    PrintStream originalErr;

    @BeforeEach
    public void setUp() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.teeOut = new XTeeOutputStream(null);
        this.teeErr = new XTeeOutputStream(null);
        System.setOut(new PrintStream((OutputStream)((Object)this.teeOut)));
        System.setErr(new PrintStream((OutputStream)((Object)this.teeErr)));
    }

    @AfterEach
    public void tearDown() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    @Override
    public Appender<Object> getAppender() {
        return new ConsoleAppender();
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        ConsoleAppender ca = new ConsoleAppender();
        ca.setEncoder(new NopEncoder());
        ca.start();
        return ca;
    }

    @Test
    public void smoke() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setEncoder(new DummyEncoder());
        ca.start();
        ca.doAppend(new Object());
        Assertions.assertEquals((Object)DummyLayout.DUMMY, (Object)this.teeOut.toString());
    }

    @Test
    public void open() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        dummyEncoder.setFileHeader("open");
        ca.setEncoder(dummyEncoder);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        Assertions.assertEquals((Object)("open" + CoreConstants.LINE_SEPARATOR + DummyLayout.DUMMY), (Object)this.teeOut.toString());
    }

    @Test
    public void testClose() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        dummyEncoder.setFileFooter("CLOSED");
        ca.setEncoder(dummyEncoder);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        Assertions.assertFalse((boolean)this.teeOut.isClosed());
        Assertions.assertEquals((Object)(DummyLayout.DUMMY + "CLOSED"), (Object)this.teeOut.toString());
    }

    @Test
    public void changeInConsole() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        EchoEncoder encoder = new EchoEncoder();
        ca.setEncoder((Encoder)encoder);
        ca.start();
        ca.doAppend((Object)"a");
        Assertions.assertEquals((Object)("a" + CoreConstants.LINE_SEPARATOR), (Object)this.teeOut.toString());
        XTeeOutputStream newTee = new XTeeOutputStream(null);
        System.setOut(new PrintStream((OutputStream)((Object)newTee)));
        ca.doAppend((Object)"b");
        Assertions.assertEquals((Object)("b" + CoreConstants.LINE_SEPARATOR), (Object)newTee.toString());
    }

    @Test
    public void testUTF16BE() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        Charset utf16BE = StandardCharsets.UTF_16BE;
        dummyEncoder.setCharset(utf16BE);
        ca.setEncoder(dummyEncoder);
        ca.start();
        ca.doAppend(new Object());
        Assertions.assertEquals((Object)DummyLayout.DUMMY, (Object)new String(this.teeOut.toByteArray(), utf16BE));
    }

    @Test
    public void wrongTarget() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        EchoEncoder encoder = new EchoEncoder();
        encoder.setContext(this.context);
        ca.setContext(this.context);
        ca.setTarget("foo");
        ca.setEncoder((Encoder)encoder);
        ca.start();
        ca.doAppend((Object)"a");
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch(1, "\\[foo\\] should be one of \\[System.out, System.err\\]");
    }

    @Test
    public void jansiSystemOut() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        ca.setEncoder(dummyEncoder);
        ca.setTarget("System.out");
        ca.setContext(this.context);
        ca.setWithJansi(true);
        ca.start();
        Assertions.assertTrue((boolean)(ca.getOutputStream() instanceof AnsiPrintStream));
        ca.doAppend(new Object());
    }

    @Test
    public void jansiSystemErr() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        ca.setEncoder(dummyEncoder);
        ca.setTarget("System.err");
        ca.setContext(this.context);
        ca.setWithJansi(true);
        ca.start();
        Assertions.assertTrue((boolean)(ca.getOutputStream() instanceof AnsiPrintStream));
        ca.doAppend(new Object());
    }
}

