/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.testUtil.ScaffoldingForRollingTests;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SizeAndTimeBasedFNATP_Test
extends ScaffoldingForRollingTests {
    private SizeAndTimeBasedFNATP<Object> sizeAndTimeBasedFNATP = null;
    private RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    private TimeBasedRollingPolicy<Object> tbrp1 = new TimeBasedRollingPolicy();
    private RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    private TimeBasedRollingPolicy<Object> tbrp2 = new TimeBasedRollingPolicy();
    private EchoEncoder<Object> encoder = new EchoEncoder();
    int fileSize = 0;
    int fileIndexCounter = 0;
    int sizeThreshold = 0;
    static final boolean FIRST_PHASE_ONLY = false;
    static final boolean WITH_SECOND_PHASE = true;
    static final String DEFAULT_COMPRESSION_SUFFIX = "";

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    private void initRollingFileAppender(RollingFileAppender<Object> rfa, String filename) {
        rfa.setContext(this.context);
        rfa.setEncoder(this.encoder);
        if (filename != null) {
            rfa.setFile(filename);
        }
    }

    private void initPolicies(RollingFileAppender<Object> rfa, TimeBasedRollingPolicy<Object> tbrp, String filenamePattern, int sizeThreshold, long givenTime, long lastCheck) {
        this.sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        this.sizeAndTimeBasedFNATP.setCheckIncrement(Integer.valueOf(10));
        tbrp.setContext(this.context);
        this.sizeAndTimeBasedFNATP.setMaxFileSize(new FileSize((long)sizeThreshold));
        tbrp.setTimeBasedFileNamingAndTriggeringPolicy(this.sizeAndTimeBasedFNATP);
        tbrp.setFileNamePattern(filenamePattern);
        tbrp.setParent(rfa);
        tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(givenTime);
        rfa.setRollingPolicy(tbrp);
        tbrp.start();
        rfa.start();
    }

    private void addExpectedFileNamedIfItsTime(String randomOutputDir, String testId, String msg, String compressionSuffix) {
        this.fileSize += msg.getBytes().length;
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.fileIndexCounter = 0;
            this.fileSize = 0;
            this.addExpectedFileName_ByFileIndexCounter(randomOutputDir, testId, this.getMillisOfCurrentPeriodsStart(), this.fileIndexCounter, compressionSuffix);
            this.recomputeRolloverThreshold(this.currentTime);
            return;
        }
        if (this.fileIndexCounter == 0 && this.fileSize > this.sizeThreshold) {
            this.addExpectedFileName_ByFileIndexCounter(randomOutputDir, testId, this.getMillisOfCurrentPeriodsStart(), this.fileIndexCounter, compressionSuffix);
            ++this.fileIndexCounter;
            this.fileSize = 0;
        }
    }

    void generic(String testId, UnaryOperator<String> filenameFunction, boolean withSecondPhase, String compressionSuffix) throws IOException, InterruptedException, ExecutionException {
        String file = (String)filenameFunction.apply(testId);
        this.initRollingFileAppender(this.rfa1, file);
        this.sizeThreshold = 300;
        this.initPolicies(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt" + compressionSuffix, this.sizeThreshold, this.currentTime, 0L);
        this.addExpectedFileName_ByFileIndexCounter(this.randomOutputDir, testId, this.getMillisOfCurrentPeriodsStart(), this.fileIndexCounter, compressionSuffix);
        this.incCurrentTime(100L);
        this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
        int runLength = 100;
        String prefix = "Hello -----------------";
        for (int i = 0; i < runLength; ++i) {
            String msg = prefix + i;
            this.rfa1.doAppend((Object)msg);
            this.addExpectedFileNamedIfItsTime(this.randomOutputDir, testId, msg, compressionSuffix);
            this.incCurrentTime(20L);
            this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            this.add(this.tbrp1.compressionFuture);
            this.add(this.tbrp1.cleanUpFuture);
        }
        if (withSecondPhase) {
            this.secondPhase(testId, filenameFunction, compressionSuffix, runLength, prefix);
            runLength *= 2;
        }
        if (file != null) {
            this.massageExpectedFilesToCorresponToCurrentTarget(testId, x$0 -> this.testId2FileName((String)x$0));
        }
        Thread.yield();
        this.waitForJobsToComplete();
        SizeAndTimeBasedFNATP_Test.existenceCheck(this.expectedFilenameList);
        SizeAndTimeBasedFNATP_Test.sortedContentCheck(this.randomOutputDir, runLength, prefix);
    }

    void secondPhase(String testId, UnaryOperator<String> filenameFunction, String compressionSuffix, int runLength, String prefix) {
        this.rfa1.stop();
        String filename = (String)filenameFunction.apply(testId);
        if (filename != null) {
            File f = new File(filename);
            f.setLastModified(this.currentTime);
        }
        StatusManager sm = this.context.getStatusManager();
        sm.add((Status)new InfoStatus("Time when rfa1 is stopped: " + new Date(this.currentTime), (Object)this));
        sm.add((Status)new InfoStatus("currentTime%1000=" + this.currentTime % 1000L, (Object)this));
        this.initRollingFileAppender(this.rfa2, filename);
        this.initPolicies(this.rfa2, this.tbrp2, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt" + compressionSuffix, this.sizeThreshold, this.currentTime, 0L);
        for (int i = runLength; i < runLength * 2; ++i) {
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            String msg = prefix + i;
            this.rfa2.doAppend((Object)msg);
            this.addExpectedFileNamedIfItsTime(this.randomOutputDir, testId, msg, compressionSuffix);
        }
    }

    @Test
    public void noCompression_FileSet_NoRestart_1() throws InterruptedException, ExecutionException, IOException {
        this.generic("test1", x$0 -> this.testId2FileName((String)x$0), false, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void noCompression_FileBlank_NoRestart_2() throws Exception {
        this.generic("test2", x$0 -> this.nullFileName((String)x$0), false, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void noCompression_FileBlank_WithStopStart_3() throws Exception {
        this.generic("test3", x$0 -> this.nullFileName((String)x$0), true, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void noCompression_FileSet_WithStopStart_4() throws Exception {
        this.generic("test4", x$0 -> this.testId2FileName((String)x$0), true, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void withGZCompression_FileSet_NoRestart_5() throws Exception {
        this.generic("test5", x$0 -> this.testId2FileName((String)x$0), false, ".gz");
    }

    @Test
    public void withGZCompression_FileBlank_NoRestart_6() throws Exception {
        this.generic("test6", x$0 -> this.nullFileName((String)x$0), false, ".gz");
    }

    @Test
    public void withZipCompression_FileSet_NoRestart_7() throws Exception {
        this.generic("test7", x$0 -> this.testId2FileName((String)x$0), false, ".zip");
        List<String> zipFiles = this.filterElementsInListBySuffix(".zip");
        this.checkZipEntryMatchesZipFilename(zipFiles);
    }

    @Test
    public void checkMissingIntToken() {
        String stem = "toto.log";
        String testId = "checkMissingIntToken";
        String compressionSuffix = "gz";
        String file = stem != null ? this.randomOutputDir + stem : null;
        this.initRollingFileAppender(this.rfa1, file);
        this.sizeThreshold = 300;
        this.initPolicies(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}.txt" + compressionSuffix, this.sizeThreshold, this.currentTime, 0L);
        Assertions.assertFalse((boolean)this.rfa1.isStarted());
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch("Missing integer token");
    }

    @Test
    public void checkDateCollision() {
        String stem = "toto.log";
        String testId = "checkDateCollision";
        String compressionSuffix = "gz";
        String file = stem != null ? this.randomOutputDir + stem : null;
        this.initRollingFileAppender(this.rfa1, file);
        this.sizeThreshold = 300;
        this.initPolicies(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{EE}.txt" + compressionSuffix, this.sizeThreshold, this.currentTime, 0L);
        Assertions.assertFalse((boolean)this.rfa1.isStarted());
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch("The date format in FileNamePattern");
    }
}

