/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.implicitAction;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.StatusListenerAction;
import ch.qos.logback.core.joran.implicitAction.Cake;
import ch.qos.logback.core.joran.implicitAction.Fruit;
import ch.qos.logback.core.joran.implicitAction.FruitContext;
import ch.qos.logback.core.joran.implicitAction.FruitContextAction;
import ch.qos.logback.core.joran.implicitAction.FruitContextModel;
import ch.qos.logback.core.joran.implicitAction.FruitContextModelHandler;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.StatusListenerModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ImplicitModelHandler;
import ch.qos.logback.core.model.processor.PropertyModelHandler;
import ch.qos.logback.core.model.processor.StatusListenerModelHandler;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImplicitActionTest {
    static final String IMPLCIT_DIR = "src/test/input/joran/implicitAction/";
    FruitContext fruitContext = new FruitContext();
    SimpleConfigurator simpleConfigurator;
    StatusChecker checker = new StatusChecker((Context)this.fruitContext);

    @Before
    public void setUp() throws Exception {
        this.fruitContext.setName("fruits");
        HashMap<ElementSelector, Supplier<Action>> rulesMap = new HashMap<ElementSelector, Supplier<Action>>();
        rulesMap.put(new ElementSelector("/context/"), () -> new FruitContextAction());
        rulesMap.put(new ElementSelector("/context/statusListener"), () -> new StatusListenerAction());
        this.simpleConfigurator = new SimpleConfigurator(rulesMap){

            protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
                defaultProcessor.addHandler(FruitContextModel.class, FruitContextModelHandler::makeInstance);
                defaultProcessor.addHandler(PropertyModel.class, PropertyModelHandler::makeInstance);
                defaultProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
                defaultProcessor.addHandler(StatusListenerModel.class, StatusListenerModelHandler::makeInstance);
            }
        };
        this.simpleConfigurator.setContext((Context)this.fruitContext);
    }

    void verifyFruit() {
        List<Fruit> fList = this.fruitContext.getFruitList();
        Assert.assertNotNull(fList);
        Assert.assertEquals((long)1L, (long)fList.size());
        Fruit f0 = fList.get(0);
        Assert.assertEquals((Object)"blue", (Object)f0.getName());
        Assert.assertEquals((long)2L, (long)f0.textList.size());
        Assert.assertEquals((Object)"hello", (Object)f0.textList.get(0));
        Assert.assertEquals((Object)"world", (Object)f0.textList.get(1));
    }

    @Test
    public void nestedComplex() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplex.xml");
            StatusPrinter.print((Context)this.fruitContext);
            this.verifyFruit();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    @Test
    public void nestedComplexWithoutClassAtrribute() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexWithoutClassAtrribute.xml");
            this.verifyFruit();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    void verifyFruitList() {
        List<Fruit> fList = this.fruitContext.getFruitList();
        Assert.assertNotNull(fList);
        Assert.assertEquals((long)1L, (long)fList.size());
        Fruit f0 = fList.get(0);
        Assert.assertEquals((long)2L, (long)f0.cakeList.size());
        Cake cakeA = f0.cakeList.get(0);
        Assert.assertEquals((Object)"A", (Object)cakeA.getType());
        Cake cakeB = f0.cakeList.get(1);
        Assert.assertEquals((Object)"B", (Object)cakeB.getType());
    }

    @Test
    public void nestedComplexCollection() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexCollection.xml");
            this.verifyFruitList();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    @Test
    public void nestedComplexCollectionWithoutClassAtrribute() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexCollectionWithoutClassAtrribute.xml");
            this.verifyFruitList();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    @Test
    public void statusListenerWithPrefix() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/statusListenerWithPrefix.xml");
            StatusPrinter.print((Context)this.fruitContext);
            this.checker.assertIsErrorFree();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }
}

