/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.Converter123;
import ch.qos.logback.core.pattern.ConverterHello;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConverterUtilTest {
    Map<String, String> converterMap = new HashMap<String, String>();
    Context context = new ContextBase();

    @BeforeEach
    public void setUp() {
        this.converterMap.put("OTT", Converter123.class.getName());
        this.converterMap.put("hello", ConverterHello.class.getName());
        this.converterMap.putAll(Parser.DEFAULT_COMPOSITE_CONVERTER_MAP);
    }

    @Test
    public void contextAndStartTest() throws ScanException {
        this.testContextAndStart("hi %hello");
        this.testContextAndStart("hi %(%hello)");
        this.testContextAndStart("hi %(abc %(%hello))");
    }

    private void testContextAndStart(String pattern) throws ScanException {
        Parser p = new Parser(pattern);
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        ConverterUtil.setContextForConverters((Context)this.context, (Converter)head);
        this.checkContext((Converter<Object>)head);
        ConverterUtil.startConverters((Converter)head);
        this.checkStart((Converter<Object>)head);
    }

    private void checkStart(Converter<Object> head) {
        for (Converter c = head; c != null; c = c.getNext()) {
            if (c instanceof LifeCycle) {
                LifeCycle ca = (LifeCycle)c;
                Assertions.assertTrue((boolean)ca.isStarted());
            }
            if (!(c instanceof CompositeConverter)) continue;
            CompositeConverter cc = (CompositeConverter)c;
            Converter childConverter = cc.childConverter;
            this.checkStart((Converter<Object>)childConverter);
        }
    }

    void checkContext(Converter<Object> head) {
        for (Converter c = head; c != null; c = c.getNext()) {
            if (c instanceof ContextAware) {
                ContextAware ca = (ContextAware)c;
                Assertions.assertNotNull((Object)ca.getContext());
            }
            if (!(c instanceof CompositeConverter)) continue;
            CompositeConverter cc = (CompositeConverter)c;
            Converter childConverter = cc.childConverter;
            this.checkContext((Converter<Object>)childConverter);
        }
    }
}

