/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RollingFileAppenderTest
extends AbstractAppenderTest<Object> {
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    Context context = new ContextBase();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();
    int diff = RandomUtil.getPositiveInt();
    String randomOutputDir = "target/test-output/" + this.diff + "/";

    @BeforeEach
    public void setUp() throws Exception {
        this.rfa.setEncoder(new DummyEncoder());
        this.rfa.setName("test");
        this.tbrp.setContext(this.context);
        this.tbrp.setParent(this.rfa);
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Override
    protected Appender<Object> getAppender() {
        return this.rfa;
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        this.rfa.setContext(this.context);
        this.tbrp.setFileNamePattern("target/test-output/toto-%d.log");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        return this.rfa;
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        this.rfa.setContext(this.context);
        this.rfa.setFile("some non null value");
        this.rfa.setAppend(false);
        this.rfa.setPrudent(true);
        this.tbrp.setFileNamePattern("target/test-output/toto-%d.log");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        Assertions.assertTrue((boolean)this.rfa.isAppend());
        Assertions.assertNull((Object)this.rfa.rawFileProperty());
        Assertions.assertTrue((boolean)this.rfa.isStarted());
    }

    @Test
    public void testPrudentModeLogicalImplicationsOnCompression() {
        this.rfa.setContext(this.context);
        this.rfa.setAppend(false);
        this.rfa.setPrudent(true);
        this.tbrp.setFileNamePattern("target/test-output/toto-%d.log.zip");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        StatusChecker checker = new StatusChecker(this.context);
        Assertions.assertFalse((boolean)this.rfa.isStarted());
        Assertions.assertEquals((int)2, (int)checker.getHighestLevel(0L));
    }

    @Test
    public void testFilePropertyAfterRollingPolicy() {
        this.rfa.setContext(this.context);
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.setFile("x");
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        statusChecker.assertContainsMatch(2, "File property must be set before any triggeringPolicy ");
    }

    @Test
    public void testFilePropertyAfterTriggeringPolicy() {
        this.rfa.setContext(this.context);
        this.rfa.setTriggeringPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy());
        this.rfa.setFile("x");
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        statusChecker.assertContainsMatch(2, "File property must be set before any triggeringPolicy ");
    }

    @Test
    public void testFileNameWithParenthesis() {
        this.rfa.setContext(this.context);
        this.tbrp.setFileNamePattern(this.randomOutputDir + "program(x86)/toto-%d.log");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        this.rfa.doAppend((Object)"hello");
    }

    @Test
    public void stopTimeBasedRollingPolicy() {
        this.rfa.setContext(this.context);
        this.tbrp.setFileNamePattern("target/test-output/toto-%d.log.zip");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        Assertions.assertTrue((boolean)this.tbrp.isStarted());
        Assertions.assertTrue((boolean)this.rfa.isStarted());
        this.rfa.stop();
        Assertions.assertFalse((boolean)this.rfa.isStarted());
        Assertions.assertFalse((boolean)this.tbrp.isStarted());
    }

    @Test
    public void stopFixedWindowRollingPolicy() {
        this.rfa.setContext(this.context);
        this.rfa.setFile("target/test-output/toto-.log");
        FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
        fwRollingPolicy.setContext(this.context);
        fwRollingPolicy.setFileNamePattern("target/test-output/toto-%i.log.zip");
        fwRollingPolicy.setParent(this.rfa);
        fwRollingPolicy.start();
        SizeBasedTriggeringPolicy sbTriggeringPolicy = new SizeBasedTriggeringPolicy();
        sbTriggeringPolicy.setContext(this.context);
        sbTriggeringPolicy.start();
        this.rfa.setRollingPolicy((RollingPolicy)fwRollingPolicy);
        this.rfa.setTriggeringPolicy((TriggeringPolicy)sbTriggeringPolicy);
        this.rfa.start();
        Assertions.assertTrue((boolean)fwRollingPolicy.isStarted());
        Assertions.assertTrue((boolean)sbTriggeringPolicy.isStarted());
        Assertions.assertTrue((boolean)this.rfa.isStarted());
        this.rfa.stop();
        Assertions.assertFalse((boolean)this.rfa.isStarted());
        Assertions.assertFalse((boolean)fwRollingPolicy.isStarted());
        Assertions.assertFalse((boolean)sbTriggeringPolicy.isStarted());
    }

    @Test
    public void testFileShouldNotMatchFileNamePattern() {
        this.rfa.setContext(this.context);
        this.rfa.setFile("target/test-output/x-2013-04.log");
        this.tbrp.setFileNamePattern("target/test-output/x-%d{yyyy-MM}.log");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        StatusChecker statusChecker = new StatusChecker(this.context);
        String msg = "File property collides with fileNamePattern. Aborting.";
        boolean containsMatch = statusChecker.containsMatch(2, "File property collides with fileNamePattern. Aborting.");
        Assertions.assertTrue((boolean)containsMatch, (String)"Missing error: File property collides with fileNamePattern. Aborting.");
    }

    @Test
    public void collidingTimeformat() {
        this.rfa.setContext(this.context);
        this.rfa.setAppend(false);
        this.rfa.setPrudent(true);
        this.tbrp.setFileNamePattern("target/test-output/toto-%d{dd}.log.zip");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        StatusChecker checker = new StatusChecker(this.context);
        Assertions.assertFalse((boolean)this.rfa.isStarted());
        Assertions.assertEquals((int)2, (int)checker.getHighestLevel(0L));
        checker.assertContainsMatch("The date format in FileNamePattern will result");
    }

    @Test
    public void collidingFileNamePattern() {
        String filenamePattern = "target/test-output/" + this.diff + "-collision-%d.log.zip";
        RollingFileAppender appender0 = new RollingFileAppender();
        appender0.setName("FA0");
        appender0.setContext(this.context);
        appender0.setEncoder(new DummyEncoder());
        TimeBasedRollingPolicy tbrp0 = new TimeBasedRollingPolicy();
        tbrp0.setContext(this.context);
        tbrp0.setFileNamePattern(filenamePattern);
        tbrp0.setParent((FileAppender)appender0);
        tbrp0.start();
        appender0.setRollingPolicy((RollingPolicy)tbrp0);
        appender0.start();
        Assertions.assertTrue((boolean)appender0.isStarted());
        RollingFileAppender appender1 = new RollingFileAppender();
        appender1.setName("FA1");
        appender1.setFile("X");
        appender1.setContext(this.context);
        appender1.setEncoder(new DummyEncoder());
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setContext(this.context);
        tbrp1.setFileNamePattern(filenamePattern);
        tbrp1.setParent((FileAppender)appender1);
        tbrp1.start();
        appender1.setRollingPolicy((RollingPolicy)tbrp1);
        appender1.start();
        Assertions.assertFalse((boolean)appender1.isStarted());
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch(2, "'FileNamePattern' option has the same value");
    }
}

