/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DatePatternToRegexTest {
    static Calendar CAL_2009_08_3_NIGHT = Calendar.getInstance();
    static Calendar CAL_2009_08_3_MORNING = Calendar.getInstance();
    static Locale CZ_LOCALE = new Locale("cs", "CZ");
    static Locale KO_LOCALE = new Locale("ko", "KR");
    Locale locale;

    @BeforeAll
    public static void setUpCalendars() {
        CAL_2009_08_3_NIGHT.set(2009, 8, 3, 21, 57, 16);
        CAL_2009_08_3_NIGHT.set(14, 333);
        CAL_2009_08_3_MORNING.set(2009, 8, 3, 10, 24, 37);
        CAL_2009_08_3_MORNING.set(14, 333);
    }

    @Test
    public void ISO8601() {
        this.doTest("yyyy-MM-dd HH:mm:ss,SSS", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void withQuotes() {
        this.doTest("yyyy-MM-dd'T'HH:mm:ss,SSS", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void month() {
        this.doTest("yyyy-MMM-dd", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-dd", CAL_2009_08_3_NIGHT, CZ_LOCALE);
        this.doTest("yyyy-MMM-dd", CAL_2009_08_3_NIGHT, KO_LOCALE);
        this.doTest("yyyy-MMMM-dd", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMMM-dd", CAL_2009_08_3_NIGHT, CZ_LOCALE);
        this.doTest("yyyy-MMMM-dd", CAL_2009_08_3_NIGHT, KO_LOCALE);
    }

    public void monthWithLocal() {
    }

    @Test
    public void dot() {
        this.doTest("yyyy.MMM.dd", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void timeZone() {
        this.doTest("yyyy-MMM-dd HH:mm:ss z", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-dd HH:mm:ss Z", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void dayInWeek() {
        this.doTest("EE", CAL_2009_08_3_NIGHT);
        this.doTest("EE", CAL_2009_08_3_NIGHT, CZ_LOCALE);
        this.doTest("EE", CAL_2009_08_3_NIGHT, KO_LOCALE);
        this.doTest("EEEE", CAL_2009_08_3_NIGHT);
        this.doTest("EEEE", CAL_2009_08_3_NIGHT, CZ_LOCALE);
        this.doTest("EEEE", CAL_2009_08_3_NIGHT, KO_LOCALE);
    }

    @Test
    public void amPm() {
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_NIGHT, CZ_LOCALE);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_NIGHT, KO_LOCALE);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_MORNING);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_MORNING, CZ_LOCALE);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_MORNING, KO_LOCALE);
    }

    void doTest(String datePattern, Calendar calendar) {
        this.doTest(datePattern, calendar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTest(String datePattern, Calendar calendar, Locale locale) {
        Locale oldDefaultLocale = Locale.getDefault();
        if (locale != null) {
            Locale.setDefault(locale);
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
            DateTokenConverter<?> dtc = this.makeDTC(datePattern);
            this.verify(sdf, calendar, dtc);
        }
        finally {
            if (locale != null) {
                Locale.setDefault(oldDefaultLocale);
            }
        }
    }

    void verify(SimpleDateFormat sdf, Calendar calendar, DateTokenConverter<?> dtc) {
        String expected = sdf.format(calendar.getTime());
        String regex = dtc.toRegex();
        Assertions.assertTrue((boolean)expected.matches(regex), (String)("[" + expected + "] does not match regex [" + regex + "]"));
    }

    private DateTokenConverter<?> makeDTC(String datePattern) {
        DateTokenConverter dtc = new DateTokenConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add(datePattern);
        dtc.setOptionList(optionList);
        dtc.start();
        return dtc;
    }
}

