/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StatusPrinterTest {
    ByteArrayOutputStream outputStream;
    PrintStream ps;

    @BeforeEach
    public void setUp() throws Exception {
        this.outputStream = new ByteArrayOutputStream();
        this.ps = new PrintStream(this.outputStream);
        StatusPrinter.setPrintStream((PrintStream)this.ps);
    }

    @AfterEach
    public void tearDown() throws Exception {
        StatusPrinter.setPrintStream((PrintStream)System.out);
        this.ps = null;
        this.outputStream = null;
    }

    @Test
    public void testBasic() {
        ContextBase context = new ContextBase();
        context.getStatusManager().add((Status)new InfoStatus("test", (Object)this));
        StatusPrinter.print((Context)context);
        String result = this.outputStream.toString();
        Assertions.assertTrue((boolean)result.contains("|-INFO in " + this.getClass().getName()));
    }

    @Test
    public void testNested() {
        ErrorStatus s0 = new ErrorStatus("test0", (Object)this);
        InfoStatus s1 = new InfoStatus("test1", (Object)this);
        InfoStatus s11 = new InfoStatus("test11", (Object)this);
        InfoStatus s12 = new InfoStatus("test12", (Object)this);
        s1.add((Status)s11);
        s1.add((Status)s12);
        InfoStatus s2 = new InfoStatus("test2", (Object)this);
        InfoStatus s21 = new InfoStatus("test21", (Object)this);
        WarnStatus s211 = new WarnStatus("test211", (Object)this);
        InfoStatus s22 = new InfoStatus("test22", (Object)this);
        s2.add((Status)s21);
        s2.add((Status)s22);
        s21.add((Status)s211);
        ContextBase context = new ContextBase();
        context.getStatusManager().add((Status)s0);
        context.getStatusManager().add((Status)s1);
        context.getStatusManager().add((Status)s2);
        StatusPrinter.print((Context)context);
        String result = this.outputStream.toString();
        Assertions.assertTrue((boolean)result.contains("+ INFO in " + this.getClass().getName()));
        Assertions.assertTrue((boolean)result.contains("+ WARN in " + this.getClass().getName()));
        Assertions.assertTrue((boolean)result.contains("    |-WARN in " + this.getClass().getName()));
    }

    @Test
    public void testWithException() {
        ErrorStatus s0 = new ErrorStatus("test0", (Object)this);
        InfoStatus s1 = new InfoStatus("test1", (Object)this, (Throwable)new Exception("testEx"));
        InfoStatus s11 = new InfoStatus("test11", (Object)this);
        InfoStatus s12 = new InfoStatus("test12", (Object)this);
        s1.add((Status)s11);
        s1.add((Status)s12);
        InfoStatus s2 = new InfoStatus("test2", (Object)this);
        InfoStatus s21 = new InfoStatus("test21", (Object)this);
        WarnStatus s211 = new WarnStatus("test211", (Object)this);
        InfoStatus s22 = new InfoStatus("test22", (Object)this);
        s2.add((Status)s21);
        s2.add((Status)s22);
        s21.add((Status)s211);
        ContextBase context = new ContextBase();
        context.getStatusManager().add((Status)s0);
        context.getStatusManager().add((Status)s1);
        context.getStatusManager().add((Status)s2);
        StatusPrinter.print((Context)context);
        String result = this.outputStream.toString();
        Assertions.assertTrue((boolean)result.contains("|-ERROR in " + this.getClass().getName()));
        Assertions.assertTrue((boolean)result.contains("+ INFO in " + this.getClass().getName()));
        Assertions.assertTrue((boolean)result.contains("ch.qos.logback.core.util.StatusPrinterTest.testWithException"));
    }
}

