/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.recovery.RecoveryCoordinator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecoveryCoordinatorTest {
    long now = System.currentTimeMillis();
    RecoveryCoordinator rc = new RecoveryCoordinator(this.now);

    @Test
    public void recoveryNotNeededAfterInit() {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        Assertions.assertTrue((boolean)rc.isTooSoon());
    }

    @Test
    public void recoveryNotNeededIfAsleepForLessThanBackOffTime() throws InterruptedException {
        this.rc.setCurrentTime(this.now + 10L);
        Assertions.assertTrue((boolean)this.rc.isTooSoon());
    }

    @Test
    public void recoveryNeededIfAsleepForMoreThanBackOffTime() throws InterruptedException {
        this.rc.setCurrentTime(this.now + 20L + 20L);
        Assertions.assertFalse((boolean)this.rc.isTooSoon());
    }

    @Test
    public void recoveryNotNeededIfCurrentTimeSetToBackOffTime() throws InterruptedException {
        this.rc.setCurrentTime(this.now + 20L);
        Assertions.assertTrue((boolean)this.rc.isTooSoon());
    }

    @Test
    public void recoveryNeededIfCurrentTimeSetToExceedBackOffTime() {
        this.rc.setCurrentTime(this.now + 20L + 1L);
        Assertions.assertFalse((boolean)this.rc.isTooSoon());
    }

    @Test
    public void recoveryConditionDetectedEvenAfterReallyLongTimesBetweenRecovery() {
        long offset = 20L;
        for (int i = 0; i < 16; ++i) {
            this.rc.setCurrentTime(this.now + offset);
            if (i % 2 == 0) {
                Assertions.assertTrue((boolean)this.rc.isTooSoon(), (String)("recovery should've been needed at " + offset));
            } else {
                Assertions.assertFalse((boolean)this.rc.isTooSoon(), (String)("recovery should NOT have been needed at " + offset));
            }
            offset *= 2L;
        }
    }
}

