/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.TopElementAction;
import ch.qos.logback.core.joran.action.ext.IncAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.TrivialStatusListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TrivialConfiguratorTest {
    Context context = new ContextBase();
    HashMap<ElementSelector, Supplier<Action>> rulesMap = new HashMap();

    @BeforeEach
    public void setUp() {
        this.rulesMap.put(new ElementSelector("x"), () -> new TopElementAction());
        this.rulesMap.put(new ElementSelector("x/inc"), () -> new IncAction());
    }

    public void doTest(String filename) throws Exception {
        TrivialConfigurator trivialConfigurator = new TrivialConfigurator(this.rulesMap);
        trivialConfigurator.setContext(this.context);
        trivialConfigurator.doConfigure(filename);
    }

    @Test
    public void smoke() throws Exception {
        int oldBeginCount = IncAction.beginCount;
        int oldEndCount = IncAction.endCount;
        int oldErrorCount = IncAction.errorCount;
        this.doTest("src/test/input/joran/inc.xml");
        Assertions.assertEquals((int)oldErrorCount, (int)IncAction.errorCount);
        Assertions.assertEquals((int)(oldBeginCount + 1), (int)IncAction.beginCount);
        Assertions.assertEquals((int)(oldEndCount + 1), (int)IncAction.endCount);
    }

    @Test
    public void inexistentFile() {
        TrivialStatusListener tsl = new TrivialStatusListener();
        tsl.start();
        String filename = "src/test/input/joran/nothereBLAH.xml";
        this.context.getStatusManager().add((StatusListener)tsl);
        try {
            this.doTest(filename);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Could not open ["));
        }
        Assertions.assertTrue((tsl.list.size() >= 1 ? 1 : 0) != 0, (String)(tsl.list.size() + " should be greater than or equal to 1"));
        Status s0 = (Status)tsl.list.get(0);
        Assertions.assertTrue((boolean)s0.getMessage().startsWith("Could not open ["));
    }

    @Test
    public void illFormedXML() {
        TrivialStatusListener tsl = new TrivialStatusListener();
        tsl.start();
        String filename = "src/test/input/joran/illformed.xml";
        this.context.getStatusManager().add((StatusListener)tsl);
        try {
            this.doTest(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)tsl.list.size());
        Status s0 = (Status)tsl.list.get(0);
        Assertions.assertTrue((boolean)s0.getMessage().startsWith("XML_PARSING"));
    }

    @Test
    public void lbcore105() throws IOException, JoranException {
        String jarEntry = "buzz.xml";
        File jarFile = this.makeRandomJarFile();
        this.fillInJarFile(jarFile, jarEntry);
        URL url = this.asURL(jarFile, jarEntry);
        TrivialConfigurator tc = new TrivialConfigurator(this.rulesMap);
        tc.setContext(this.context);
        tc.doConfigure(url);
        Assertions.assertTrue((boolean)jarFile.delete());
        Assertions.assertFalse((boolean)jarFile.exists());
    }

    @Test
    public void lbcore127() throws IOException, JoranException {
        String jarEntry = "buzz.xml";
        String jarEntry2 = "lightyear.xml";
        File jarFile = this.makeRandomJarFile();
        this.fillInJarFile(jarFile, jarEntry, jarEntry2);
        URL url1 = this.asURL(jarFile, jarEntry);
        URL url2 = this.asURL(jarFile, jarEntry2);
        URLConnection urlConnection2 = url2.openConnection();
        urlConnection2.setUseCaches(false);
        InputStream is = urlConnection2.getInputStream();
        TrivialConfigurator tc = new TrivialConfigurator(this.rulesMap);
        tc.setContext(this.context);
        tc.doConfigure(url1);
        is.read();
        is.close();
        Assertions.assertTrue((boolean)jarFile.delete());
        Assertions.assertFalse((boolean)jarFile.exists());
    }

    File makeRandomJarFile() {
        File outputDir = new File("target/test-output/");
        outputDir.mkdirs();
        int randomPart = RandomUtil.getPositiveInt();
        return new File("target/test-output/foo-" + randomPart + ".jar");
    }

    private void fillInJarFile(File jarFile, String jarEntryName) throws IOException {
        this.fillInJarFile(jarFile, jarEntryName, null);
    }

    private void fillInJarFile(File jarFile, String jarEntryName1, String jarEntryName2) throws IOException {
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        jos.putNextEntry(new ZipEntry(jarEntryName1));
        jos.write("<x/>".getBytes());
        jos.closeEntry();
        if (jarEntryName2 != null) {
            jos.putNextEntry(new ZipEntry(jarEntryName2));
            jos.write("<y/>".getBytes());
            jos.closeEntry();
        }
        jos.close();
    }

    URL asURL(File jarFile, String jarEntryName) throws IOException {
        URL innerURL = jarFile.toURI().toURL();
        return new URL("jar:" + String.valueOf(innerURL) + "!/" + jarEntryName);
    }
}

