/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrudentModeTest {
    FileAppender<Object> fa = new FileAppender();
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/prudentLockTest-" + this.diff + "/";
    String logfileStr = this.outputDirStr + "output.log";
    private static final int THREAD_COUNT = 8;
    private static final int LOOP_COUNT = 12;

    @BeforeEach
    public void beforeEach() {
        File outputDir = new File(this.outputDirStr);
        if (!outputDir.mkdirs()) {
            Assertions.fail((String)("failed to create folder " + String.valueOf(outputDir)));
        }
        this.fa.setContext(this.context);
        this.fa.setName("FILE");
        this.fa.setPrudent(true);
        this.fa.setEncoder((Encoder)new EchoEncoder());
        this.fa.setFile(this.logfileStr);
        this.fa.start();
    }

    @Test
    public void assertNoOverlappingFileLockException() throws IOException {
        int i;
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> threads = new ArrayList<Object>(8);
        for (i = 0; i < 8; ++i) {
            LoggerThread thread = new LoggerThread(latch, "message from thread " + i);
            thread.start();
            threads.add(thread);
        }
        latch.countDown();
        i = 0;
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        StatusPrinter.print((Context)this.context);
        this.statusChecker.assertIsWarningOrErrorFree();
        this.fa.stop();
        File file = new File(this.logfileStr);
        List<String> list = Files.readAllLines(file.toPath());
        int actualLineCount = list.size();
        Assertions.assertEquals((int)96, (int)actualLineCount, (String)("unexpected line count " + actualLineCount));
    }

    class LoggerThread
    extends Thread {
        private final CountDownLatch latch;
        private final String message;

        LoggerThread(CountDownLatch latch, String message) {
            this.setDaemon(false);
            this.latch = latch;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                for (int i = 0; i < 12; ++i) {
                    if ((i & 8) == 0) {
                        Thread.yield();
                    }
                    PrudentModeTest.this.fa.doAppend((Object)(this.message + " i=" + i));
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        void delay(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

