/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CachingDateFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CachingDateFotmatterTest {
    static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    TimeZone perthTZ = TimeZone.getTimeZone("Australia/Perth");
    TimeZone utcTZ = TimeZone.getTimeZone("UTC");

    @BeforeEach
    public void setUp() {
        this.sdf.setTimeZone(this.utcTZ);
    }

    @Test
    public void timeZoneIsTakenIntoAccount() throws ParseException {
        ZoneId perthZone = ZoneId.of("Australia/Perth");
        CachingDateFormatter cdf = new CachingDateFormatter(DATE_PATTERN, perthZone);
        Date march26_2015_0949_UTC = this.sdf.parse("2015-03-26T09:49");
        System.out.print(march26_2015_0949_UTC);
        String result = cdf.format(march26_2015_0949_UTC.getTime());
        Assertions.assertEquals((Object)"2015-03-26T17:49", (Object)result);
    }
}

