/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.AggregationAssessor;
import ch.qos.logback.core.joran.util.Door;
import ch.qos.logback.core.joran.util.House;
import ch.qos.logback.core.joran.util.LargeSwimmingPoolImpl;
import ch.qos.logback.core.joran.util.SwimmingPoolImpl;
import ch.qos.logback.core.joran.util.Window;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.util.AggregationType;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregationAssessorTest {
    Context context = new ContextBase();
    AggregationAssessor aggregationAssessor = new AggregationAssessor(new BeanDescriptionCache(this.context), House.class);
    DefaultNestedComponentRegistry defaultComponentRegistry = new DefaultNestedComponentRegistry();

    @Test
    public void testgetClassNameViaImplicitRules() {
        Class compClass = this.aggregationAssessor.getClassNameViaImplicitRules("door", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assertions.assertEquals(Door.class, (Object)compClass);
    }

    @Test
    public void testgetComplexPropertyColleClassNameViaImplicitRules() {
        Class compClass = this.aggregationAssessor.getClassNameViaImplicitRules("window", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assertions.assertEquals(Window.class, (Object)compClass);
    }

    @Test
    public void testDefaultClassAnnotationForLists() {
        Method relevantMethod = this.aggregationAssessor.getRelevantMethod("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION);
        Assertions.assertNotNull((Object)relevantMethod);
        Class spClass = this.aggregationAssessor.getDefaultClassNameByAnnonation("LargeSwimmingPool", relevantMethod);
        Assertions.assertEquals(LargeSwimmingPoolImpl.class, (Object)spClass);
        Class classViaImplicitRules = this.aggregationAssessor.getClassNameViaImplicitRules("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assertions.assertEquals(LargeSwimmingPoolImpl.class, (Object)classViaImplicitRules);
    }

    @Test
    public void testDefaultClassAnnonation() {
        Method relevantMethod = this.aggregationAssessor.getRelevantMethod("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY);
        Assertions.assertNotNull((Object)relevantMethod);
        Class spClass = this.aggregationAssessor.getDefaultClassNameByAnnonation("SwimmingPool", relevantMethod);
        Assertions.assertEquals(SwimmingPoolImpl.class, (Object)spClass);
        Class classViaImplicitRules = this.aggregationAssessor.getClassNameViaImplicitRules("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assertions.assertEquals(SwimmingPoolImpl.class, (Object)classViaImplicitRules);
    }
}

