/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.xml.sax.Attributes;

public class SaxEventRecorderTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);

    SAXParser createParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser();
    }

    public List<SaxEvent> doTest(String filename) throws Exception {
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        FileInputStream fis = new FileInputStream("src/test/input/joran/" + filename);
        recorder.recordEvents((InputStream)fis);
        return recorder.getSaxEventList();
    }

    public void dump(List<SaxEvent> seList) {
        for (SaxEvent se : seList) {
            System.out.println(se);
        }
    }

    @Test
    public void testEvent1() throws Exception {
        System.out.println("test1");
        List<SaxEvent> seList = this.doTest("event1.xml");
        StatusPrinter.print((Context)this.context);
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)11, (int)seList.size());
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testEventSSRF() throws Exception {
        try {
            List<SaxEvent> seList = this.doTest("event-ssrf.xml");
            Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 1 ? 1 : 0) != 0);
            this.statusChecker.assertContainsMatch(1, "Document Type Declaration");
            Assertions.assertEquals((int)11, (int)seList.size());
        }
        finally {
            StatusPrinter.print((Context)this.context);
        }
    }

    @Test
    public void testEventAmp() throws Exception {
        List<SaxEvent> seList = this.doTest("ampEvent.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assertions.assertEquals((Object)"xxx & yyy", (Object)be.getText());
    }

    @Test
    public void testInc() throws Exception {
        List<SaxEvent> seList = this.doTest("inc.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)seList.size());
        StartEvent se = (StartEvent)seList.get(1);
        Attributes attr = se.getAttributes();
        Assertions.assertNotNull((Object)attr);
        Assertions.assertEquals((Object)"1", (Object)attr.getValue("increment"));
    }

    @Test
    public void bodyWithSpacesAndQuotes() throws Exception {
        List<SaxEvent> seList = this.doTest("spacesAndQuotes.xml");
        Assertions.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assertions.assertEquals((Object)"[x][x] \"xyz\"%n", (Object)be.getText());
    }
}

