/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimeBasedFileNamingAndTriggeringPolicyBaseTest {
    static long MILLIS_IN_MINUTE = 60000L;
    static long MILLIS_IN_HOUR = 60L * MILLIS_IN_MINUTE;
    Context context = new ContextBase();
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();
    DefaultTimeBasedFileNamingAndTriggeringPolicy<Object> timeBasedFNATP = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    StatusChecker statusChecker = new StatusChecker(this.context);

    @BeforeEach
    public void setUp() {
        this.rfa.setContext(this.context);
        this.tbrp.setContext(this.context);
        this.timeBasedFNATP.setContext(this.context);
        this.rfa.setRollingPolicy(this.tbrp);
        this.tbrp.setParent(this.rfa);
        this.tbrp.setTimeBasedFileNamingAndTriggeringPolicy(this.timeBasedFNATP);
        this.timeBasedFNATP.setTimeBasedRollingPolicy(this.tbrp);
    }

    @Test
    public void doublePolicySet() {
        this.rfa.setTriggeringPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy());
        this.statusChecker.assertContainsMatch(1, "A triggering policy of type ");
    }

    @Test
    public void singleDate() {
        long startTime = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM'T'mm}.log");
        this.timeBasedFNATP.setCurrentTime(startTime);
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(startTime + MILLIS_IN_MINUTE);
        boolean result = this.timeBasedFNATP.isTriggeringEvent(null, null);
        StatusPrinter.print((Context)this.context);
        Assertions.assertTrue((boolean)result);
        String elapsedPeriodsFileName = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assertions.assertEquals((Object)"foo-2011-12T59.log", (Object)elapsedPeriodsFileName);
    }

    @Test
    public void multiDate() {
        long startTime = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM, AUX}/%d{mm}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(startTime);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(startTime + MILLIS_IN_MINUTE);
        boolean triggerred = this.timeBasedFNATP.isTriggeringEvent(null, null);
        Assertions.assertTrue((boolean)triggerred);
        String elapsedPeriodsFileName = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assertions.assertEquals((Object)"foo-2011-12/59.log", (Object)elapsedPeriodsFileName);
    }

    @Test
    public void withTimeZone() {
        long startTime = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM-dd, GMT+5}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(startTime);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(startTime + MILLIS_IN_MINUTE + 2L * MILLIS_IN_HOUR);
        boolean triggerred = this.timeBasedFNATP.isTriggeringEvent(null, null);
        Assertions.assertTrue((boolean)triggerred);
        String elapsedPeriodsFileName = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assertions.assertEquals((Object)"foo-2011-12-20.log", (Object)elapsedPeriodsFileName);
    }

    @Test
    public void extraIntegerTokenInFileNamePatternShouldBeDetected() {
        String pattern = "test-%d{yyyy-MM-dd'T'HH}-%i.log.zip";
        this.tbrp.setFileNamePattern(pattern);
        this.tbrp.start();
        Assertions.assertFalse((boolean)this.tbrp.isStarted());
        StatusChecker statusChecker = new StatusChecker(this.context);
        statusChecker.assertContainsMatch(2, "Filename pattern .{37} contains an integer token converter");
    }
}

