/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.Compare;
import ch.qos.logback.core.util.StatusPrinter2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JDKOnlyCompressTest {
    Context context = new ContextBase();
    StatusPrinter2 statusPrinter2 = new StatusPrinter2();
    final String original1 = "src/test/input/compress1.original";
    final String copy1 = "src/test/input/compress1.txt";
    final String compressed1 = "target/test-output/compress1.txt.gz";
    final String original2 = "src/test/input/compress2.original";
    final String copy2 = "src/test/input/compress2.txt";
    final String compressed2 = "target/test-output/compress2.txt.gz";
    final String original3 = "src/test/input/compress3.original";
    final String copy3 = "src/test/input/compress3.txt";
    final String compressed3 = "target/test-output/compress3.txt.zip";
    final String original4 = "src/test/input/compress4.original";
    final String copy4 = "src/test/input/compress4.txt";
    final String compressed4 = "target/test-output/compress4.txt.xz";

    @BeforeEach
    public void setUp() throws IOException {
    }

    protected void copySourceFilesAndDeleteCompressedOutputFiles(String originalPathStr, String copyPathStr, String compressedStr) throws IOException {
        File originalFile = new File(originalPathStr);
        File copyFile = new File(copyPathStr);
        this.copy(originalFile, copyFile);
        File compressedFile = new File(compressedStr);
        compressedFile.mkdirs();
        compressedFile.delete();
    }

    protected void copy(File src, File dst) throws IOException {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    @Test
    public void gzTest1() throws Exception {
        this.copySourceFilesAndDeleteCompressedOutputFiles("src/test/input/compress1.original", "src/test/input/compress1.txt", "target/test-output/compress1.txt.gz");
        Compressor compressor = new Compressor(CompressionMode.GZ);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress1.txt", "target/test-output/compress1.txt.gz", null);
        StatusChecker checker = new StatusChecker(this.context);
        Assertions.assertTrue((boolean)checker.isErrorFree(0L));
        Assertions.assertTrue((boolean)Compare.gzCompare("target/test-output/compress1.txt.gz", "src/test/witness/compress1.txt.gz"));
    }

    @Test
    public void gzTest2() throws Exception {
        this.copySourceFilesAndDeleteCompressedOutputFiles("src/test/input/compress2.original", "src/test/input/compress2.txt", "target/test-output/compress2.txt.gz");
        Compressor compressor = new Compressor(CompressionMode.GZ);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress2.txt", "target/test-output/compress2.txt.gz", null);
        StatusChecker checker = new StatusChecker(this.context);
        Assertions.assertTrue((boolean)checker.isErrorFree(0L));
        Assertions.assertTrue((boolean)Compare.gzCompare("target/test-output/compress2.txt.gz", "src/test/witness/compress2.txt.gz"));
    }

    @Test
    public void zipTest() throws Exception {
        this.copySourceFilesAndDeleteCompressedOutputFiles("src/test/input/compress3.original", "src/test/input/compress3.txt", "target/test-output/compress3.txt.zip");
        Compressor compressor = new Compressor(CompressionMode.ZIP);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress3.txt", "target/test-output/compress3.txt.zip", "compress3.txt");
        StatusChecker checker = new StatusChecker(this.context);
        Assertions.assertTrue((boolean)checker.isErrorFree(0L));
    }

    @Test
    public void xzTest() throws Exception {
        this.copySourceFilesAndDeleteCompressedOutputFiles("src/test/input/compress4.original", "src/test/input/compress4.txt", "target/test-output/compress4.txt.xz");
        Compressor compressor = new Compressor(CompressionMode.XZ);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress4.txt", "target/test-output/compress4.txt.xz", null);
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch(2, "Could not instantiate ch.qos.logback.core.rolling.helper.XZCompressionStrategy");
        checker.assertContainsMatch(1, "Could not obtain compression strategy");
    }
}

