/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.util.Compare;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileUtilTest {
    Context context = new ContextBase();
    FileUtil fileUtil = new FileUtil(this.context);
    List<File> cleanupList = new ArrayList<File>();
    int diff = new Random().nextInt(10000);

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
        for (File f : this.cleanupList) {
            f.delete();
        }
    }

    @Test
    public void checkParentCreationInquiryAndSubsequentCreation() {
        File file = new File("target/test-output//fu" + this.diff + "/testing.txt");
        this.cleanupList.add(file);
        this.cleanupList.add(file.getParentFile());
        Assertions.assertFalse((boolean)file.getParentFile().exists());
        Assertions.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
        Assertions.assertTrue((boolean)file.getParentFile().exists());
    }

    @Test
    public void checkDeeperParentCreationInquiryAndSubsequentCreation() {
        File file = new File("target/test-output//fu" + this.diff + "/bla/testing.txt");
        this.cleanupList.add(file);
        this.cleanupList.add(file.getParentFile());
        this.cleanupList.add(file.getParentFile().getParentFile());
        Assertions.assertFalse((boolean)file.getParentFile().exists());
        Assertions.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
        Assertions.assertTrue((boolean)file.getParentFile().exists());
    }

    @Test
    public void basicCopyingWorks() throws IOException {
        String dir = "target/test-output//fu" + this.diff;
        File dirFile = new File(dir);
        dirFile.mkdir();
        String src = "src/test/input/compress1.original";
        String target = "target/test-output//fu" + this.diff + "/copyingWorks.txt";
        this.fileUtil.copy(src, target);
        Compare.compare(src, target);
    }

    @Test
    public void createParentDirIgnoresExistingDir() {
        String target = "target/test-output//fu" + this.diff + "/testing.txt";
        File file = new File(target);
        this.cleanupList.add(file);
        file.mkdirs();
        Assertions.assertTrue((boolean)file.getParentFile().exists());
        Assertions.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
    }

    @Test
    public void createParentDirAcceptsNoParentSpecified() {
        File file = new File("testing.txt");
        Assertions.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
    }
}

