/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue;

import ch.qos.logback.core.testUtil.RunnableWithCounterAndDone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SelectiveLockRunnable
extends RunnableWithCounterAndDone {
    static Object LOCK = new Object();
    static Lock FAIR_LOCK = new ReentrantLock(true);
    static Lock UNFAIR_LOCK = new ReentrantLock(false);
    LockingModel model;

    SelectiveLockRunnable(LockingModel model) {
        this.model = model;
    }

    public void run() {
        switch (this.model.ordinal()) {
            case 0: {
                this.nolockRun();
                break;
            }
            case 1: {
                this.synchronizedRun();
                break;
            }
            case 2: {
                this.fairLockRun();
                break;
            }
            case 3: {
                this.unfairLockRun();
            }
        }
    }

    void fairLockRun() {
        do {
            FAIR_LOCK.lock();
            ++this.counter;
            FAIR_LOCK.unlock();
        } while (!this.done);
    }

    void unfairLockRun() {
        do {
            UNFAIR_LOCK.lock();
            ++this.counter;
            UNFAIR_LOCK.unlock();
        } while (!this.done);
    }

    void nolockRun() {
        do {
            ++this.counter;
        } while (!this.done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizedRun() {
        do {
            Object object = LOCK;
            synchronized (object) {
                ++this.counter;
            }
        } while (!this.done);
    }

    public String toString() {
        return "SelectiveLockRunnable " + String.valueOf((Object)this.model);
    }

    static enum LockingModel {
        NOLOCK,
        SYNC,
        FAIR,
        UNFAIR;

    }
}

