/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.Converter123;
import ch.qos.logback.core.pattern.ConverterHello;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CompilerTest {
    Map<String, Supplier<DynamicConverter>> converterMap = new HashMap<String, Supplier<DynamicConverter>>();
    Context context = new ContextBase();

    @BeforeEach
    public void setUp() {
        this.converterMap.put("OTT", Converter123::new);
        this.converterMap.put("hello", ConverterHello::new);
        this.converterMap.putAll(Parser.DEFAULT_COMPOSITE_CONVERTER_MAP);
    }

    String write(Converter<Object> head, Object event) {
        StringBuilder buf = new StringBuilder();
        for (Converter c = head; c != null; c = c.getNext()) {
            c.write(buf, event);
        }
        return buf.toString();
    }

    @Test
    public void testLiteral() throws Exception {
        Parser p = new Parser("hello");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"hello", (Object)result);
    }

    @Test
    public void testBasic() throws Exception {
        Parser p = new Parser("abc %hello");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc Hello", (Object)result);
        p = new Parser("abc %hello %OTT");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc Hello 123", (Object)result);
    }

    @Test
    public void converterStart() throws Exception {
        Parser p = new Parser("abc %hello");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc Hello", (Object)result);
    }

    @Test
    public void testFormat() throws Exception {
        Parser p = new Parser("abc %7hello");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc   Hello", (Object)result);
        p = new Parser("abc %-7hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc Hello  ", (Object)result);
        p = new Parser("abc %.3hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc llo", (Object)result);
        p = new Parser("abc %.-3hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc Hel", (Object)result);
        p = new Parser("abc %4.5OTT");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc  123", (Object)result);
        p = new Parser("abc %-4.5OTT");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc 123 ", (Object)result);
        p = new Parser("abc %3.4hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc ello", (Object)result);
        p = new Parser("abc %-3.-4hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"abc Hell", (Object)result);
    }

    @Test
    public void testComposite() throws Exception {
        ContextBase c = new ContextBase();
        Parser p = new Parser("%(ABC %hello)");
        p.setContext((Context)c);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"ABC Hello", (Object)result);
        Parser p2 = new Parser("%(ABC %hello)");
        p2.setContext(this.context);
        Node t2 = p2.parse();
        Converter head2 = p2.compile(t2, this.converterMap);
        String result2 = this.write((Converter<Object>)head2, new Object());
        Assertions.assertEquals((Object)"ABC Hello", (Object)result2);
    }

    @Test
    public void testCompositeFormatting() throws Exception {
        Parser p = new Parser("xyz %4.10(ABC)");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"xyz  ABC", (Object)result);
        p = new Parser("xyz %-4.10(ABC)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"xyz ABC ", (Object)result);
        p = new Parser("xyz %.2(ABC %hello)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"xyz lo", (Object)result);
        p = new Parser("xyz %.-2(ABC)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"xyz AB", (Object)result);
        p = new Parser("xyz %30.30(ABC %20hello)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"xyz       ABC                Hello", (Object)result);
    }

    @Test
    public void testUnknownWord() throws Exception {
        Parser p = new Parser("%unknown");
        p.setContext(this.context);
        Node t = p.parse();
        p.compile(t, this.converterMap);
        StatusChecker checker = new StatusChecker(this.context.getStatusManager());
        checker.assertContainsMatch("\\[unknown] is not a valid conversion word");
    }

    @Test
    public void testWithNopEscape() throws Exception {
        Parser p = new Parser("xyz %hello\\_world");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assertions.assertEquals((Object)"xyz Helloworld", (Object)result);
    }
}

