/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.ConcurrentServerRunner;
import ch.qos.logback.core.net.server.MockClient;
import ch.qos.logback.core.net.server.MockClientVisitor;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.test.MockServerListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConcurrentServerRunnerTest {
    private static final int DELAY = 10000;
    private static final int SHORT_DELAY = 10;
    private MockContext context = new MockContext();
    private MockServerListener<MockClient> listener = new MockServerListener();
    private ExecutorService executor = Executors.newCachedThreadPool();
    private InstrumentedConcurrentServerRunner runner = new InstrumentedConcurrentServerRunner(this.listener, this.executor);

    @BeforeEach
    public void setUp() throws Exception {
        this.runner.setContext((Context)this.context);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
        Assertions.assertTrue((boolean)this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartStop() throws Exception {
        Assertions.assertFalse((boolean)this.runner.isRunning());
        this.executor.execute((Runnable)((Object)this.runner));
        Assertions.assertTrue((boolean)this.runner.awaitRunState(true, 10000L));
        int retries = 1000;
        MockServerListener<MockClient> mockServerListener = this.listener;
        synchronized (mockServerListener) {
            while (retries-- > 0 && this.listener.getWaiter() == null) {
                this.listener.wait(10L);
            }
        }
        Assertions.assertNotNull((Object)this.listener.getWaiter());
        this.runner.stop();
        Assertions.assertTrue((boolean)this.listener.isClosed());
        Assertions.assertFalse((boolean)this.runner.awaitRunState(false, 10000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunOneClient() throws Exception {
        this.executor.execute((Runnable)((Object)this.runner));
        MockClient client = new MockClient();
        this.listener.addClient(client);
        int retries = 1000;
        MockClient mockClient = client;
        synchronized (mockClient) {
            while (retries-- > 0 && !client.isRunning()) {
                client.wait(10L);
            }
        }
        Assertions.assertTrue((boolean)this.runner.awaitRunState(true, 10000L));
        client.close();
        this.runner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunManyClients() throws Exception {
        this.executor.execute((Runnable)((Object)this.runner));
        int count = 10;
        while (count-- > 0) {
            MockClient client = new MockClient();
            this.listener.addClient(client);
            int retries = 1000;
            MockClient mockClient = client;
            synchronized (mockClient) {
                while (retries-- > 0 && !client.isRunning()) {
                    client.wait(10L);
                }
            }
            Assertions.assertTrue((boolean)this.runner.awaitRunState(true, 10000L));
        }
        this.runner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunClientAndVisit() throws Exception {
        this.executor.execute((Runnable)((Object)this.runner));
        MockClient client = new MockClient();
        this.listener.addClient(client);
        int retries = 1000;
        MockClient mockClient = client;
        synchronized (mockClient) {
            while (retries-- > 0 && !client.isRunning()) {
                client.wait(10L);
            }
        }
        Assertions.assertTrue((boolean)this.runner.awaitRunState(true, 10000L));
        MockClientVisitor visitor = new MockClientVisitor();
        this.runner.accept(visitor);
        Assertions.assertSame((Object)client, (Object)visitor.getLastVisited());
        this.runner.stop();
    }

    static class InstrumentedConcurrentServerRunner
    extends ConcurrentServerRunner<MockClient> {
        private final Lock lock = new ReentrantLock();
        private final Condition runningCondition = this.lock.newCondition();

        public InstrumentedConcurrentServerRunner(ServerListener<MockClient> listener, Executor executor) {
            super(listener, executor);
        }

        protected boolean configureClient(MockClient client) {
            return true;
        }

        protected void setRunning(boolean running) {
            this.lock.lock();
            try {
                super.setRunning(running);
                this.runningCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean awaitRunState(boolean state, long delay) throws InterruptedException {
            this.lock.lock();
            try {
                while (this.isRunning() != state) {
                    this.runningCondition.await(delay, TimeUnit.MILLISECONDS);
                }
                boolean bl = this.isRunning();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

