/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.CaseCombinator;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.Attributes;

public class SimpleRuleStoreTest {
    SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
    CaseCombinator cc = new CaseCombinator();

    @Test
    public void smoke() throws Exception {
        this.srs.addRule(new ElementSelector("a/b"), () -> new XAction());
        for (String s : this.cc.combinations("a/b")) {
            System.out.println("s=" + s);
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            if (r.get() instanceof XAction) continue;
            Assertions.fail((String)"Wrong type");
        }
    }

    @Test
    public void smokeII() throws Exception {
        this.srs.addRule(new ElementSelector("a/b"), () -> new XAction());
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.srs.addRule(new ElementSelector("a/b"), () -> new YAction()));
        Assertions.assertEquals((Object)"[a][b] already has an associated action supplier", (Object)e.getMessage());
    }

    @Test
    public void testSlashSuffix() throws Exception {
        ElementSelector pa = new ElementSelector("a/");
        this.srs.addRule(pa, () -> new XAction());
        for (String s : this.cc.combinations("a")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            if (r.get() instanceof XAction) continue;
            Assertions.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail1() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), () -> new XAction());
        for (String s : this.cc.combinations("a/b")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            if (r.get() instanceof XAction) continue;
            Assertions.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail2() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new ElementSelector("*/c"), () -> new XAction());
        for (String s : this.cc.combinations("a/b/c")) {
            Supplier r = srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            if (r.get() instanceof XAction) continue;
            Assertions.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail3() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), () -> new XAction());
        this.srs.addRule(new ElementSelector("*/a/b"), () -> new YAction());
        for (String s : this.cc.combinations("a/b")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            Action ya = (Action)r.get();
            if (ya instanceof YAction) continue;
            Assertions.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail4() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), () -> new XAction());
        this.srs.addRule(new ElementSelector("*/a/b"), () -> new YAction());
        this.srs.addRule(new ElementSelector("a/b"), () -> new ZAction());
        for (String s : this.cc.combinations("a/b")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            if (r.get() instanceof ZAction) continue;
            Assertions.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSuffix() throws Exception {
        this.srs.addRule(new ElementSelector("a"), () -> new XAction());
        this.srs.addRule(new ElementSelector("a/*"), () -> new YAction());
        for (String s : this.cc.combinations("a/b")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            Assertions.assertTrue((boolean)(r.get() instanceof YAction));
        }
    }

    @Test
    public void testDeepSuffix() throws Exception {
        this.srs.addRule(new ElementSelector("a"), () -> new XAction(1));
        this.srs.addRule(new ElementSelector("a/b/*"), () -> new XAction(2));
        for (String s : this.cc.combinations("a/other")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNull((Object)r);
        }
    }

    @Test
    public void testPrefixSuffixInteraction1() throws Exception {
        this.srs.addRule(new ElementSelector("a"), () -> new ZAction());
        this.srs.addRule(new ElementSelector("a/*"), () -> new YAction());
        this.srs.addRule(new ElementSelector("*/a/b"), () -> new XAction(3));
        for (String s : this.cc.combinations("a/b")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNotNull((Object)r);
            Action ra = (Action)r.get();
            Assertions.assertTrue((boolean)(ra instanceof XAction));
            XAction xaction = (XAction)ra;
            Assertions.assertEquals((int)3, (int)xaction.id);
        }
    }

    @Test
    public void testPrefixSuffixInteraction2() throws Exception {
        this.srs.addRule(new ElementSelector("tG"), () -> new XAction());
        this.srs.addRule(new ElementSelector("tG/tS"), () -> new YAction());
        this.srs.addRule(new ElementSelector("tG/tS/test"), () -> new ZAction());
        this.srs.addRule(new ElementSelector("tG/tS/test/*"), () -> new XAction(9));
        for (String s : this.cc.combinations("tG/tS/toto")) {
            Supplier r = this.srs.matchActions(new ElementPath(s));
            Assertions.assertNull((Object)r);
        }
    }

    @Test
    public void withTransparentParts() throws Exception {
        this.srs.addTransparentPathPart("if");
        this.srs.addTransparentPathPart("then");
        this.srs.addTransparentPathPart("else");
        ElementPath ep = new ElementPath("x/if/then/if");
        ElementPath witness = new ElementPath("x/");
        ElementPath cleanedEP = this.srs.removeTransparentPathParts(ep);
        Assertions.assertEquals((Object)witness, (Object)cleanedEP);
        ep = new ElementPath("x/if/then/stack");
        witness = new ElementPath("x/stack");
        cleanedEP = this.srs.removeTransparentPathParts(ep);
        Assertions.assertEquals((Object)witness, (Object)cleanedEP);
        ep = new ElementPath("x/if/then/if/else/stack");
        witness = new ElementPath("x/stack");
        cleanedEP = this.srs.removeTransparentPathParts(ep);
        Assertions.assertEquals((Object)witness, (Object)cleanedEP);
    }

    @Test
    public void withRenamedParts() throws Exception {
        this.srs.addPathPathMapping("included", "configure");
        ElementPath ep = new ElementPath("included/a/b");
        ElementPath witness = new ElementPath("configure/a/b");
        ElementPath renamedEP = this.srs.renamePathParts(ep);
        Assertions.assertEquals((Object)witness, (Object)renamedEP);
    }

    class XAction
    extends Action {
        int id = 0;

        XAction() {
        }

        XAction(int id) {
            this.id = id;
        }

        public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(SaxEventInterpretationContext ec, String name) {
        }

        public void finish(SaxEventInterpretationContext ec) {
        }

        public String toString() {
            return "XAction(" + this.id + ")";
        }
    }

    class YAction
    extends Action {
        YAction() {
        }

        public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(SaxEventInterpretationContext ec, String name) {
        }

        public void finish(SaxEventInterpretationContext ec) {
        }
    }

    class ZAction
    extends Action {
        ZAction() {
        }

        public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(SaxEventInterpretationContext ec, String name) {
        }

        public void finish(SaxEventInterpretationContext ec) {
        }
    }
}

