/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.util.Door;
import ch.qos.logback.core.joran.util.House;
import ch.qos.logback.core.joran.util.HouseColor;
import ch.qos.logback.core.joran.util.Orange;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.SwimmingPoolImpl;
import ch.qos.logback.core.joran.util.Window;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.StatusPrinter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PropertySetterTest {
    Context context = new ContextBase();
    StatusChecker checker = new StatusChecker(this.context);
    House house = new House();
    PropertySetter setter = new PropertySetter(new BeanDescriptionCache(this.context), (Object)this.house);

    @BeforeEach
    public void setUp() {
        this.setter.setContext(this.context);
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testCanAggregateComponent() {
        Assertions.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY, (Object)this.setter.computeAggregationType("door"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("count"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Count"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("name"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Name"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Duration"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("fs"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("open"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Open"));
        Assertions.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, (Object)this.setter.computeAggregationType("Window"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY_COLLECTION, (Object)this.setter.computeAggregationType("adjective"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("filterReply"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("houseColor"));
    }

    @Test
    public void testSetProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter(new BeanDescriptionCache(this.context), (Object)house);
        setter.setProperty("count", "10");
        setter.setProperty("temperature", "33.1");
        setter.setProperty("name", "jack");
        setter.setProperty("open", "true");
        Assertions.assertEquals((int)10, (int)house.getCount());
        Assertions.assertEquals((double)33.1, (double)house.getTemperature(), (double)0.01);
        Assertions.assertEquals((Object)"jack", (Object)house.getName());
        Assertions.assertTrue((boolean)house.isOpen());
        house = new House();
        setter = new PropertySetter(new BeanDescriptionCache(this.context), (Object)house);
        setter.setProperty("Count", "10");
        setter.setProperty("Name", "jack");
        setter.setProperty("Open", "true");
        Assertions.assertEquals((int)10, (int)house.getCount());
        Assertions.assertEquals((Object)"jack", (Object)house.getName());
        Assertions.assertTrue((boolean)house.isOpen());
    }

    @Test
    public void testSetCamelProperty() {
        this.setter.setProperty("camelCase", "trot");
        Assertions.assertEquals((Object)"trot", (Object)this.house.getCamelCase());
        this.setter.setProperty("camelCase", "gh");
        Assertions.assertEquals((Object)"gh", (Object)this.house.getCamelCase());
    }

    @Test
    public void testSetComplexProperty() {
        Door door = new Door();
        this.setter.setComplexProperty("door", (Object)door);
        Assertions.assertEquals((Object)door, (Object)this.house.getDoor());
    }

    @Test
    public void testPropertyCollection() {
        this.setter.addBasicProperty("adjective", "nice");
        this.setter.addBasicProperty("adjective", "big");
        Assertions.assertEquals((int)2, (int)this.house.adjectiveList.size());
        Assertions.assertEquals((Object)"nice", (Object)this.house.adjectiveList.get(0));
        Assertions.assertEquals((Object)"big", (Object)this.house.adjectiveList.get(1));
    }

    @Test
    public void addValueOfTest() {
        this.setter.addBasicProperty("fileSize", "1GB");
        this.setter.addBasicProperty("fileSize", "10KB");
        Assertions.assertEquals((int)2, (int)this.house.fileSizes.size());
        Assertions.assertEquals((Object)FileSize.valueOf((String)"1GB"), (Object)this.house.fileSizes.get(0));
        Assertions.assertEquals((Object)FileSize.valueOf((String)"10KB"), (Object)this.house.fileSizes.get(1));
    }

    @Test
    public void testComplexCollection() {
        Window w1 = new Window();
        w1.handle = 10;
        Window w2 = new Window();
        w2.handle = 20;
        this.setter.addComplexProperty("window", (Object)w1);
        this.setter.addComplexProperty("window", (Object)w2);
        Assertions.assertEquals((int)2, (int)this.house.windowList.size());
        Assertions.assertEquals((int)10, (int)this.house.windowList.get((int)0).handle);
        Assertions.assertEquals((int)20, (int)this.house.windowList.get((int)1).handle);
    }

    @Test
    public void testSetComplexWithCamelCaseName() {
        SwimmingPoolImpl pool = new SwimmingPoolImpl();
        this.setter.setComplexProperty("swimmingPool", (Object)pool);
        Assertions.assertEquals((Object)pool, (Object)this.house.getSwimmingPool());
    }

    @Test
    public void testDuration() {
        this.setter.setProperty("duration", "1.4 seconds");
        Assertions.assertEquals((long)1400L, (long)this.house.getDuration().getMilliseconds());
    }

    @Test
    public void testFileSize() {
        this.setter.setProperty("fs", "2 kb");
        Assertions.assertEquals((long)2048L, (long)this.house.getFs().getSize());
    }

    @Test
    public void testFilterReply() {
        this.setter.setProperty("filterReply", "ACCEPT");
        Assertions.assertEquals((Object)FilterReply.ACCEPT, (Object)this.house.getFilterReply());
    }

    @Test
    public void testEnum() {
        this.setter.setProperty("houseColor", "BLUE");
        Assertions.assertEquals((Object)((Object)HouseColor.BLUE), (Object)((Object)this.house.getHouseColor()));
    }

    @Test
    public void charset() {
        this.setter.setProperty("charset", "UTF-8");
        Assertions.assertEquals((Object)Charset.forName("UTF-8"), (Object)this.house.getCharset());
        this.house.setCharset(null);
        this.setter.setProperty("charset", "UTF");
        Assertions.assertNull((Object)this.house.getCharset());
        StatusChecker checker = new StatusChecker(this.context);
        checker.containsException(UnsupportedCharsetException.class);
    }

    @Test
    public void bridgeMethodsShouldBeIgnored() {
        Orange orange = new Orange();
        PropertySetter orangeSetter = new PropertySetter(new BeanDescriptionCache(this.context), (Object)orange);
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)orangeSetter.computeAggregationType("pericarp"));
        Assertions.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)orangeSetter.computeAggregationType("prefix"));
        StatusPrinter.print((Context)this.context);
        this.checker.assertIsWarningOrErrorFree();
    }
}

