/*
 * Decompiled with CFR 0.152.
 */
package chapter7;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import chapter7.NumberCruncher;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NumberCruncherServer
extends UnicastRemoteObject
implements NumberCruncher {
    private static final long serialVersionUID = 1L;
    static Logger logger = LoggerFactory.getLogger(NumberCruncherServer.class);

    public int[] factor(int number) throws RemoteException {
        try {
            MDC.put((String)"client", (String)NumberCruncherServer.getClientHost());
        }
        catch (ServerNotActiveException e) {
            logger.warn("Caught unexpected ServerNotActiveException.", (Throwable)e);
        }
        MDC.put((String)"number", (String)String.valueOf(number));
        logger.info("Beginning to factor.");
        if (number <= 0) {
            throw new IllegalArgumentException(number + " is not a positive integer.");
        }
        if (number == 1) {
            return new int[]{1};
        }
        Vector<Integer> factors = new Vector<Integer>();
        int n = number;
        for (int i = 2; i <= n && i * i <= number; ++i) {
            logger.debug("Trying " + i + " as a factor.");
            if (n % i == 0) {
                logger.info("Found factor " + i);
                factors.addElement(new Integer(i));
                while ((n /= i) % i == 0) {
                }
            }
            NumberCruncherServer.delay(100);
        }
        if (n != 1) {
            logger.info("Found factor " + n);
            factors.addElement(new Integer(n));
        }
        int len = factors.size();
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (Integer)factors.elementAt(i);
        }
        MDC.remove((String)"client");
        MDC.remove((String)"number");
        return result;
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java chapter7.NumberCruncherServer configFile\n   where configFile is a logback configuration file.");
        System.exit(1);
    }

    public static void delay(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String configFile;
        if (args.length != 1) {
            NumberCruncherServer.usage("Wrong number of arguments.");
        }
        if ((configFile = args[0]).endsWith(".xml")) {
            try {
                LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)lc);
                lc.reset();
                configurator.doConfigure(args[0]);
            }
            catch (JoranException je) {
                je.printStackTrace();
            }
        }
        try {
            NumberCruncherServer ncs = new NumberCruncherServer();
            logger.info("Creating registry.");
            Registry registry = LocateRegistry.createRegistry(1099);
            registry.rebind("Factor", ncs);
            logger.info("NumberCruncherServer bound and ready.");
        }
        catch (Exception e) {
            logger.error("Could not bind NumberCruncherServer.", (Throwable)e);
            return;
        }
    }
}

