/*
 * Decompiled with CFR 0.152.
 */
package chapter7;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.MDC;

public class UserServletFilter
implements Filter {
    boolean userRegistered = false;
    private final String userKey = "username";

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Principal principal = req.getUserPrincipal();
        if (principal != null) {
            String username = principal.getName();
            this.registerUsername(username);
        } else {
            HttpSession session = req.getSession();
            String username = (String)session.getAttribute("username");
            this.registerUsername(username);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (this.userRegistered) {
                MDC.remove((String)"username");
            }
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private void registerUsername(String username) {
        if (username != null && username.trim().length() > 0) {
            MDC.put((String)"username", (String)username);
            this.userRegistered = true;
        }
    }
}

