/*
 * Decompiled with CFR 0.152.
 */
package chapters.appenders;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import chapters.appenders.Counter;
import org.slf4j.Logger;

public class IO
extends Thread {
    static String msgLong = "ABCDEGHIJKLMNOPQRSTUVWXYZabcdeghijklmnopqrstuvwxyz1234567890";
    static String msgShort = "Hello";
    static boolean scarceCPU;
    static int numThreads;
    static long l;
    static boolean longMessage;
    long len;
    boolean buffered;
    boolean immediateFlush;
    Logger logger;
    LoggerContext context;
    double throughput;

    public IO(boolean _buffered, boolean _immediateFlush, long _len) {
        this.len = _len;
        this.buffered = _buffered;
        this.immediateFlush = _immediateFlush;
        this.context = new LoggerContext();
        this.logger = this.context.getLogger("logger-" + this.getName());
        FileAppender fa = new FileAppender();
        if (longMessage) {
            PatternLayoutEncoder pa = new PatternLayoutEncoder();
            pa.setPattern("%r %5p %c [%t] - %m%n");
            pa.setContext((Context)this.context);
            pa.start();
            fa.setEncoder((Encoder)pa);
        } else {
            fa.setEncoder((Encoder)new EchoEncoder());
        }
        fa.setFile(this.getName() + ".log");
        fa.setAppend(false);
        fa.setContext((Context)this.context);
        fa.start();
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 4) {
            IO.usage("Wrong number of arguments.");
        }
        l = Integer.parseInt(argv[0]);
        numThreads = Integer.parseInt(argv[1]);
        scarceCPU = "true".equalsIgnoreCase(argv[2]);
        longMessage = "long".equalsIgnoreCase(argv[3]);
        IO.perfCase(false, true, l);
        IO.perfCase(false, false, l);
        IO.perfCase(true, false, l);
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + IO.class.getName() + " runLength numThreads scarceCPU (short|long)\n   runLength (integer) the number of logs to generate perthread\n   numThreads (integer) the number of threads.\n   scarceCPU (boolean) if true an additional CPU intensive thread is created\n   (short|long) length of log messages.");
        System.exit(1);
    }

    static void perfCase(boolean buffered, boolean immediateFlush, long len) throws Exception {
        int i;
        IO[] threads = new IO[numThreads];
        Counter counterThread = null;
        if (scarceCPU) {
            counterThread = new Counter();
            counterThread.start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new IO(buffered, immediateFlush, len);
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        double sum = 0.0;
        for (int i2 = 0; i2 < numThreads; ++i2) {
            threads[i2].join();
            sum += threads[i2].throughput;
        }
        if (scarceCPU) {
            counterThread.interrupted = true;
            counterThread.join();
        }
        System.out.println("On average throughput of " + sum / (double)numThreads * 1000.0 + " logs per microsecond.");
        System.out.println("------------------------------------------------");
    }

    @Override
    public void run() {
        String msg = msgShort;
        if (longMessage) {
            msg = msgLong;
        }
        long before = System.nanoTime();
        int i = 0;
        while ((long)i < this.len) {
            this.logger.debug(msg);
            ++i;
        }
        this.throughput = (double)this.len * 1.0 / (double)(System.nanoTime() - before);
        System.out.println(this.getName() + ", buffered: " + this.buffered + ", immediateFlush: " + this.immediateFlush + ", throughput: " + this.throughput + " logs per nanosecond.");
    }
}

