/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.ContextNameModel;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.ImportModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ImportModelHandler;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.AppenderModelHandler;
import ch.qos.logback.tyler.base.handler.AppenderRefModelHandler;
import ch.qos.logback.tyler.base.handler.ConfigurationModelHandler;
import ch.qos.logback.tyler.base.handler.ContextNameModelHandler;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandler;
import ch.qos.logback.tyler.base.handler.LoggerModelHandler;
import ch.qos.logback.tyler.base.handler.RootLoggerModelHandler;
import ch.qos.logback.tyler.base.handler.VariableModelHandler;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.xml.sax.InputSource;

public class ModelToJava {
    Context context;

    ModelToJava(Context context) {
        this.context = context;
    }

    Model extractModel(String input) throws JoranException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes());
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId("UNKNOWN");
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        SaxEventRecorder recorder = joranConfigurator.populateSaxEventRecorder(inputSource);
        Model top = joranConfigurator.buildModelFromSaxEventList(recorder.getSaxEventList());
        return top;
    }

    public String toJava(Model topModel) throws IOException {
        TylerModelInterpretationContext tmic = new TylerModelInterpretationContext(this.context);
        tmic.setTopModel(topModel);
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules((DefaultNestedComponentRegistry)tmic.getDefaultNestedComponentRegistry());
        DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, (ModelInterpretationContext)tmic);
        this.addModelHandlerAssociations(defaultProcessor);
        defaultProcessor.process(topModel);
        tmic.configureMethodSpecBuilder.addStatement("return ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY", new Object[0]);
        MethodSpec configureMethodSpec = tmic.configureMethodSpecBuilder.build();
        tmic.tylerConfiguratorTSB.methodSpecs.addFirst(configureMethodSpec);
        TypeSpec tylerConfiguratorTypeSpec = tmic.tylerConfiguratorTSB.build();
        JavaFile javaFile = JavaFile.builder((String)"com.example.helloworld", (TypeSpec)tylerConfiguratorTypeSpec).indent("    ").build();
        StringBuffer sb = new StringBuffer();
        javaFile.writeTo((Appendable)sb);
        return sb.toString();
    }

    private void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(ConfigurationModel.class, ConfigurationModelHandler::makeInstance);
        defaultProcessor.addHandler(PropertyModel.class, VariableModelHandler::makeInstance);
        defaultProcessor.addHandler(ContextNameModel.class, ContextNameModelHandler::makeInstance);
        defaultProcessor.addHandler(ImportModel.class, ImportModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderModel.class, AppenderModelHandler::makeInstance);
        defaultProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
        defaultProcessor.addHandler(LoggerModel.class, LoggerModelHandler::makeInstance);
        defaultProcessor.addHandler(RootLoggerModel.class, RootLoggerModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderRefModel.class, AppenderRefModelHandler::makeInstance);
    }
}

