/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.util.VariableNameUtil;

public class LoggerModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    String loggerName;

    public LoggerModelHandler(Context context) {
        super(context);
    }

    protected Class<LoggerModel> getSupportedModelClass() {
        return LoggerModel.class;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new LoggerModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        LoggerModel loggerModel = (LoggerModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        this.loggerName = loggerModel.getName();
        String levelStr = loggerModel.getLevel();
        String additivityStr = loggerModel.getAdditivity();
        Boolean additivity = this.addtivityStringToBoolean(additivityStr);
        this.addJavaStatement(tmic, this.loggerName, levelStr, additivity);
        mic.pushObject((Object)this.loggerName);
    }

    private Boolean addtivityStringToBoolean(String additivityStr) {
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)additivityStr)) {
            return OptionHelper.toBoolean((String)additivityStr, (boolean)true);
        }
        return null;
    }

    private void addJavaStatement(TylerModelInterpretationContext tmic, String loggerName, String levelStr, Boolean additivity) {
        String loggerVariableName = VariableNameUtil.loggerNameToVariableName(loggerName);
        String additivityStr = additivity == null ? "null" : "Boolean." + additivity.toString().toUpperCase();
        tmic.configureMethodSpecBuilder.addStatement("$T $N = $N($S, $S, $N)", new Object[]{Logger.class, loggerVariableName, "setupLogger", loggerName, levelStr, additivityStr});
    }

    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.loggerName) {
            this.addWarn("The object [" + String.valueOf(o) + "] on the top the of the stack is not the logger pushed earlier");
        } else {
            mic.popObject();
        }
    }
}

