/*
 * Copyright (c) 2024 QOS.ch Sarl (Switzerland)
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *
 */

package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.classic.model.ContextNameModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;

import static ch.qos.logback.classic.tyler.TylerConfiguratorBase.SET_CONTEXT_NAME_METHOD_NAME;

public class ContextNameModelHandler  extends ModelHandlerBase  {

    public ContextNameModelHandler(Context context) {
        super(context);
    }

    static public ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new ContextNameModelHandler(context);
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ContextNameModel contextNameModel = (ContextNameModel) model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext) mic;

        String bodyText = contextNameModel.getBodyText();
        tmic.configureMethodSpecBuilder.addStatement("$N($S)", SET_CONTEXT_NAME_METHOD_NAME, bodyText);

    }


    void addJavaStatement(TylerModelInterpretationContext tmic, String finalBody) {
//        //
//        // context.setName(finalBody);
//
//        final String parameterName = "name";
//        final String substVarName = "substName";
//
//        MethodSpec setContextNameMethodSpec = MethodSpec.methodBuilder(SET_CONTEXT_NAME)
//                .addParameter(String.class, parameterName)
//                .returns(void.class)
//                .addStatement("$T $N = subst($N)", String.class, substVarName, parameterName)
//                .beginControlFlow("try")
//                .addStatement("$N.setName($N)", tmic.getContextFieldSpec(), substVarName)
//                .nextControlFlow("catch ($T e)", IllegalStateException.class)
//                .addStatement("addError(\"Failed to rename context as [\"+$N+\"]\")", substVarName)
//                .endControlFlow()
//                .build();

        tmic.configureMethodSpecBuilder.addStatement("$N($S)", SET_CONTEXT_NAME_METHOD_NAME, finalBody);
//        tmic.tylerConfiguratorTSB.addMethod(setContextNameMethodSpec);
    }

}
