/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.tyler.TylerConfiguratorBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class TylerModelInterpretationContext
extends ModelInterpretationContext {
    public final TypeSpec.Builder tylerConfiguratorTSB;
    public final MethodSpec.Builder configureMethodSpecBuilder;
    final FieldSpec contextFieldSpec = FieldSpec.builder(LoggerContext.class, (String)"context", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    final ParameterSpec contextParameterSpec = ParameterSpec.builder(LoggerContext.class, (String)"loggerCoontext", (Modifier[])new Modifier[0]).build();
    final ParameterSpec levelParameterSpec = ParameterSpec.builder(Level.class, (String)"level", (Modifier[])new Modifier[0]).build();

    public TylerModelInterpretationContext(Context context) {
        super(context);
        this.configureMethodSpecBuilder = this.initializeConfigureMethodSpecBuilder();
        this.tylerConfiguratorTSB = this.initializeTylerConfiguratorTSB();
    }

    TypeSpec.Builder initializeTylerConfiguratorTSB() {
        TypeSpec.Builder tsb = TypeSpec.classBuilder((String)"TylerConfigurator").addJavadoc(" <p>BEWARE: As of March 2024, TylerConfigurator generation from logback.xml configuration files is\nstill experimental and incomplete.\n<p>\n\n<p>This class, i.e. TylerConfigurator, is intended to be copied and integrated into the user's\nproject as custom configurator. It will configure logback without XML.</p>\n\n<p>It requires logback-classic version %s or later at runtime.</p>\n\n<p>Custom configurators are looked up via Java's service-provide facility. If a custom provider is\nfound, it takes precedence over logback's own configurators, e.g. DefaultJoranConfigurator.</p>\n\n<p>See also item 1 of 'Configuration at initialization' section at\n\"https://logback.qos.ch/manual/configuration.html#auto_configuration </p>\n".formatted("1.5.2"), new Object[0]).addSuperinterface(Configurator.class).superclass(TylerConfiguratorBase.class);
        return tsb;
    }

    private MethodSpec.Builder initializeConfigureMethodSpecBuilder() {
        MethodSpec.Builder msb = MethodSpec.methodBuilder((String)"configure").addJavadoc("<p>This method performs configuration per {@link $T} interface.</p>\n\n<p>If <code>TylerConfgiurator</code> is installed as a configurator service, this method will be\ncalled by logback-classic during initialization.</p>\n", new Object[]{Configurator.class}).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.contextParameterSpec).returns(Configurator.ExecutionStatus.class).addStatement("$N($N)", new Object[]{"setContext", this.contextParameterSpec});
        return msb;
    }

    public FieldSpec getContextFieldSpec() {
        return this.contextFieldSpec;
    }
}

