/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.util.VariableNameUtil;

public class AppenderRefModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public AppenderRefModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new AppenderRefModelHandler(context);
    }

    protected Class<? extends AppenderRefModel> getSupportedModelClass() {
        return AppenderRefModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        System.out.println("============ AppenderRefModelHandler");
        AppenderRefModel appenderRefModel = (AppenderRefModel)model;
        Object o = mic.peekObject();
        if (!(o instanceof String)) {
            this.inError = true;
            this.addError("Was expecting loggerName, an object of type String");
            return;
        }
        String loggerName = (String)o;
        this.addJavaStatement(tmic, loggerName, appenderRefModel.getRef());
    }

    private void addJavaStatement(TylerModelInterpretationContext tmic, String loggerName, String ref) {
        String loggerVariableName = VariableNameUtil.loggerNameToVariableName(loggerName);
        String appenderVariableName = VariableNameUtil.appenderNameToVariableName(ref);
        tmic.configureMethodSpecBuilder.addStatement("$N.addAppender($N)", new Object[]{loggerVariableName, appenderVariableName});
    }
}

