/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.tyler.TylerConfiguratorBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerConstants;
import ch.qos.logback.tyler.base.spi.StaticImportData;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public class TylerModelInterpretationContext
extends ModelInterpretationContext {
    public final TypeSpec.Builder tylerConfiguratorTSB;
    public final MethodSpec.Builder configureMethodSpecBuilder;
    final FieldSpec contextFieldSpec = FieldSpec.builder(LoggerContext.class, (String)"context", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    final ParameterSpec contextParameterSpec = ParameterSpec.builder(LoggerContext.class, (String)"loggerCoontext", (Modifier[])new Modifier[0]).build();
    final ParameterSpec levelParameterSpec = ParameterSpec.builder(Level.class, (String)"level", (Modifier[])new Modifier[0]).build();
    final List<StaticImportData> staticImportsList = new ArrayList<StaticImportData>();

    public TylerModelInterpretationContext(Context context) {
        super(context);
        this.configureMethodSpecBuilder = this.initializeConfigureMethodSpecBuilder();
        this.tylerConfiguratorTSB = this.initializeTylerConfiguratorTSB();
    }

    public void addStaticImport(StaticImportData sid) {
        if (!this.staticImportsList.contains(sid)) {
            this.staticImportsList.add(sid);
        }
    }

    TypeSpec.Builder initializeTylerConfiguratorTSB() {
        TypeSpec.Builder tsb = TypeSpec.classBuilder((String)"TylerConfigurator").addJavadoc("\n<p>This file was generated by logback-tyler version %s</p>\n\n<p>Eventual errors and warnings are appended at the end.</p>\n\n<p>You may experiment with logback.xml to Java translation, i.e.\nTylerConfigurator generation, at the following URL:\n\n      https://logback.qos.ch/translator/services/xml2Java.html </p>\n\n<p>BEWARE: As of April 2024, TylerConfigurator generation from logback.xml\nconfiguration files remains experimental and incomplete.\n</p>\n\n<p>This generated TylerConfigurator class is intended to be copied and integrated\ninto the user's project as a custom configurator. It will configure logback\nwithout XML.</p>\n\n<p>It requires logback-classic version %s or later at runtime.</p>\n\n<p>Custom configurators are looked up via Java's service-provide facility. If a\ncustom provider is found, it takes precedence over logback's own configurators,\ne.g. DefaultJoranConfigurator.</p>\n\n<p>See also item 1 of 'Configuration at initialization' section at\n\n    https://logback.qos.ch/manual/configuration.html#auto_configuration\n\n</p>\n".formatted(TylerConstants.TYLER_VERSION, "1.5.4"), new Object[0]).addSuperinterface(Configurator.class).superclass(TylerConfiguratorBase.class);
        return tsb;
    }

    private MethodSpec.Builder initializeConfigureMethodSpecBuilder() {
        MethodSpec.Builder msb = MethodSpec.methodBuilder((String)"configure").addJavadoc("<p>This method performs configuration per {@link $T} interface.</p>\n\n<p>If <code>TylerConfgiurator</code> is installed as a configurator service, this\nmethod will be called by logback-classic during initialization.</p>\n", new Object[]{Configurator.class}).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.contextParameterSpec).returns(Configurator.ExecutionStatus.class).addStatement("$N($N)", new Object[]{"setContext", this.contextParameterSpec});
        return msb;
    }

    public FieldSpec getContextFieldSpec() {
        return this.contextFieldSpec;
    }
}

