/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.ClassUtil;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;

public abstract class ComponentModelHandler
extends ModelHandlerBase {
    private boolean inError;
    ImplicitModelHandlerData implicitModelHandlerData;

    public ComponentModelHandler(Context context) {
        super(context);
    }

    abstract String getTargetType();

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ComponentModel componentModel = (ComponentModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String componentClassName = componentModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)componentClassName)) {
            this.addWarn("Missing className. This should have been caught earlier.");
            this.inError = true;
            return;
        }
        componentClassName = mic.getImport(componentClassName);
        this.addInfo("About to configure " + this.getTargetType() + " of type [" + componentClassName + "]");
        MethodSpec.Builder methodSpec = this.addJavaStatement(tmic, componentClassName);
        this.addAdditionalJavaStatement(methodSpec, componentModel);
        this.implicitModelHandlerData = ImplicitModelHandlerData.makeInstance((ContextAware)this, methodSpec, componentClassName);
        if (this.implicitModelHandlerData != null) {
            mic.pushObject((Object)this.implicitModelHandlerData);
        } else {
            this.addError("Could not make implicitModelHandlerData for [" + componentClassName + "]");
            model.markAsSkipped();
            this.inError = true;
        }
    }

    protected void addAdditionalJavaStatement(MethodSpec.Builder methodSpec, ComponentModel componentModel) {
    }

    MethodSpec.Builder addJavaStatement(TylerModelInterpretationContext tmic, String componentClassName) {
        String simpleName = ClassUtil.extractSimpleClassName(componentClassName);
        ClassName desiredComponentCN = ClassName.get((String)ClassUtil.extractPackageName(componentClassName), (String)simpleName, (String[])new String[0]);
        String variableName = VariableNameUtil.fullyQualifiedClassNameToVariableName(componentClassName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)("setup" + simpleName)).returns(Void.TYPE).addStatement("$1T $2N = new $1T()", new Object[]{desiredComponentCN, variableName}).addStatement("$N.setContext($N)", new Object[]{variableName, tmic.getContextFieldSpec()});
        return methodSpecBuilder;
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addWarn("The object at the of the stack is not the implicitModelHandlerData pushed earlier.");
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.popObject();
            MethodSpec.Builder componentMethodBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            String variableName = this.implicitModelHandlerData.getVariableName();
            componentMethodBuilder.addCode("\n", new Object[0]);
            componentMethodBuilder.beginControlFlow("if($N instanceof $T)", new Object[]{variableName, LifeCycle.class});
            componentMethodBuilder.addStatement("(($T)$N).start()", new Object[]{LifeCycle.class, variableName});
            componentMethodBuilder.endControlFlow();
            MethodSpec statusListenerMethodSpec = componentMethodBuilder.build();
            tmic.tylerConfiguratorTSB.addMethod(statusListenerMethodSpec);
            tmic.configureMethodSpecBuilder.addStatement("$N()", new Object[]{statusListenerMethodSpec});
        }
    }
}

