/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.MethodSpec;

public class ImplicitModelHandlerData {
    final String parentVariableName;
    final Class parentObjectClass;
    final String variableName;
    final MethodSpec.Builder methodSpecBuilder;

    public ImplicitModelHandlerData(Class parentObjectClass, String variableName, MethodSpec.Builder methodSpecBuilder) {
        this(null, parentObjectClass, variableName, methodSpecBuilder);
    }

    public ImplicitModelHandlerData(String parentVariableName, Class parentObjectClass, String variableName, MethodSpec.Builder methodSpecBuilder) {
        this.parentVariableName = parentVariableName;
        this.parentObjectClass = parentObjectClass;
        this.variableName = variableName;
        this.methodSpecBuilder = methodSpecBuilder;
    }

    public String getParentVariableName() {
        return this.parentVariableName;
    }

    public Class getParentObjectClass() {
        return this.parentObjectClass;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public MethodSpec.Builder getMethodSpecBuilder() {
        return this.methodSpecBuilder;
    }

    public static ImplicitModelHandlerData makeInstance(ContextAware contextAware, MethodSpec.Builder methodSpec, String fqcn) {
        String variableName = VariableNameUtil.fullyQualifiedClassNameToVariableName(fqcn);
        try {
            Class<?> aClass = Class.forName(fqcn);
            ImplicitModelHandlerData implicitModelHandlerData = new ImplicitModelHandlerData(aClass, variableName, methodSpec);
            return implicitModelHandlerData;
        }
        catch (ClassNotFoundException e) {
            contextAware.addError("Could not find class [" + fqcn + "]");
            return null;
        }
    }
}

