/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.util.StringToVariableStament;
import ch.qos.logback.tyler.base.util.VariableNameUtil;

public class RootLoggerModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public RootLoggerModelHandler(Context context) {
        super(context);
    }

    protected Class<RootLoggerModel> getSupportedModelClass() {
        return RootLoggerModel.class;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new RootLoggerModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        RootLoggerModel rootLoggerModel = (RootLoggerModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String levelStr = rootLoggerModel.getLevel();
        this.addJavaStatement(tmic, "ROOT", levelStr);
        mic.pushObject((Object)"ROOT");
    }

    private void addJavaStatement(TylerModelInterpretationContext tmic, String loggerName, String levelStr) {
        String loggerVariableName = VariableNameUtil.loggerNameToVariableName(loggerName);
        boolean containsVariable = StringToVariableStament.containsVariable(levelStr);
        String levelStrPart = containsVariable ? "subst($S)" : "$S";
        tmic.configureMethodSpecBuilder.addStatement("$T $N = $N($S, " + levelStrPart + ", $N)", new Object[]{Logger.class, loggerVariableName, "setupLogger", loggerName, levelStr, "null"});
    }

    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (!(o instanceof String)) {
            this.addWarn("The object [" + String.valueOf(o) + "] on the top the of the stack is not the data pushed earlier");
        } else {
            mic.popObject();
        }
    }
}

