/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.IncludeModelHandler;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;

public class TylerIncludeModelHandler
extends ModelHandlerBase {
    public TylerIncludeModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new TylerIncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        IncludeModel includeModel = (IncludeModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        this.addJavaStatement(tmic, includeModel);
    }

    protected void addJavaStatement(TylerModelInterpretationContext tmic, IncludeModel originalModel) {
        String includeModelVarName = "includeModel";
        String imhVarName = "includeModelHandler";
        String mfifVarName = "modelFromIncludedFile";
        tmic.configureMethodSpecBuilder.addStatement("$1T $2N = new $1T()", new Object[]{IncludeModel.class, includeModelVarName});
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)originalModel.getFile())) {
            tmic.configureMethodSpecBuilder.addStatement("$N.setFile(subst($S))", new Object[]{includeModelVarName, originalModel.getFile()});
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)originalModel.getUrl())) {
            tmic.configureMethodSpecBuilder.addStatement("$N.setUrl(subst($S))", new Object[]{includeModelVarName, originalModel.getUrl()});
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)originalModel.getResource())) {
            tmic.configureMethodSpecBuilder.addStatement("$N.setResource(subst($S))", new Object[]{includeModelVarName, originalModel.getResource()});
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)originalModel.getOptional())) {
            tmic.configureMethodSpecBuilder.addStatement("$N.setOptional(subst($S))", new Object[]{includeModelVarName, originalModel.getOptional()});
        }
        tmic.configureMethodSpecBuilder.addStatement("$1T $2N = new $1T($3N)", new Object[]{IncludeModelHandler.class, imhVarName, tmic.getContextFieldSpec()});
        tmic.configureMethodSpecBuilder.beginControlFlow("try", new Object[0]);
        tmic.configureMethodSpecBuilder.addStatement("$T $N = $N.buildModelFromIncludedFile(this, $N)", new Object[]{Model.class, mfifVarName, imhVarName, includeModelVarName});
        tmic.configureMethodSpecBuilder.addStatement("processModelFromIncludedFile($N)", new Object[]{mfifVarName});
        tmic.configureMethodSpecBuilder.nextControlFlow("catch($T e)", new Object[]{ModelHandlerException.class});
        tmic.configureMethodSpecBuilder.addStatement("addError(\"Failed to process IncludeModelHandler\", e)", new Object[0]);
        tmic.configureMethodSpecBuilder.endControlFlow();
    }
}

