/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.ContextNameModel;
import ch.qos.logback.classic.model.LevelModel;
import ch.qos.logback.classic.model.LoggerContextListenerModel;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.PropertiesConfiguratorModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.ImportModel;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.InsertFromJNDIModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.SequenceNumberGeneratorModel;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.StatusListenerModel;
import ch.qos.logback.core.model.TimestampModel;
import ch.qos.logback.core.model.conditional.ElseModel;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.conditional.ThenModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ImportModelHandler;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.StatusPrinter2;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.AppenderModelHandler;
import ch.qos.logback.tyler.base.handler.AppenderRefModelHandler;
import ch.qos.logback.tyler.base.handler.ConfigurationModelHandler;
import ch.qos.logback.tyler.base.handler.ContextNameModelHandler;
import ch.qos.logback.tyler.base.handler.DefineModelHandler;
import ch.qos.logback.tyler.base.handler.ElseModelHandler;
import ch.qos.logback.tyler.base.handler.IfModelHandler;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandler;
import ch.qos.logback.tyler.base.handler.LevelModelHandler;
import ch.qos.logback.tyler.base.handler.LoggerContextListenerModelHandler;
import ch.qos.logback.tyler.base.handler.LoggerModelHandler;
import ch.qos.logback.tyler.base.handler.RootLoggerModelHandler;
import ch.qos.logback.tyler.base.handler.SequenceNumberGeneratorModelHandler;
import ch.qos.logback.tyler.base.handler.ShutdownHookModelHandler;
import ch.qos.logback.tyler.base.handler.StatusListenerModelHandler;
import ch.qos.logback.tyler.base.handler.ThenModelHandler;
import ch.qos.logback.tyler.base.handler.TimestampModelHandler;
import ch.qos.logback.tyler.base.handler.TylerIncludeModelHandler;
import ch.qos.logback.tyler.base.handler.TylerInsertFromJNDIModelHandler;
import ch.qos.logback.tyler.base.handler.TylerPropertiesConfiguratorModelHandler;
import ch.qos.logback.tyler.base.handler.VariableModelHandler;
import ch.qos.logback.tyler.base.util.StringPrintStream;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.InputSource;

public class ModelToJava {
    final Context context;

    public ModelToJava(Context context) {
        this.context = context;
    }

    public Model extractModel(String input) throws JoranException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes());
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId("UNKNOWN");
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        SaxEventRecorder recorder = joranConfigurator.populateSaxEventRecorder(inputSource);
        Model top = joranConfigurator.buildModelFromSaxEventList(recorder.getSaxEventList());
        return top;
    }

    public StringBuffer toJavaAsStringBuffer(Model topModel) throws IOException {
        TylerModelInterpretationContext tmic = new TylerModelInterpretationContext(this.context);
        tmic.setTopModel(topModel);
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules((DefaultNestedComponentRegistry)tmic.getDefaultNestedComponentRegistry());
        DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, (ModelInterpretationContext)tmic);
        this.addModelHandlerAssociations(defaultProcessor);
        defaultProcessor.process(topModel);
        tmic.configureMethodSpecBuilder.addStatement("return ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY", new Object[0]);
        MethodSpec configureMethodSpec = tmic.configureMethodSpecBuilder.build();
        tmic.tylerConfiguratorTSB.methodSpecs.addFirst(configureMethodSpec);
        for (String methodName : tmic.mapOfMethodSpecBuilders.keySet()) {
            MethodSpec.Builder methodSpecBuilder = tmic.mapOfMethodSpecBuilders.get(methodName);
            MethodSpec methodSpec = methodSpecBuilder.build();
            tmic.tylerConfiguratorTSB.methodSpecs.add(methodSpec);
        }
        TypeSpec tylerConfiguratorTypeSpec = tmic.tylerConfiguratorTSB.build();
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)"com.example", (TypeSpec)tylerConfiguratorTypeSpec);
        tmic.staticImportsList.forEach(sid -> javaFileBuilder.addStaticImport(sid.aClass(), new String[]{sid.methodName()}));
        JavaFile javaFile = javaFileBuilder.indent("  ").build();
        StringBuffer sb = new StringBuffer();
        javaFile.writeTo((Appendable)sb);
        return sb;
    }

    public String toJava(Model topModel) throws IOException {
        StringBuffer buf = this.toJavaAsStringBuffer(topModel);
        return buf.toString();
    }

    public List<String> statusToStringList() {
        ArrayList<String> resultList = new ArrayList<String>();
        StatusPrinter2 statusPrinter2 = new StatusPrinter2();
        StringPrintStream sps = new StringPrintStream(System.out, false);
        statusPrinter2.setPrintStream((PrintStream)sps);
        statusPrinter2.print(this.context);
        for (String s : sps.stringList) {
            String[] split = s.split("\n");
            Arrays.stream(split).forEach(n -> resultList.add("// " + n));
        }
        return resultList;
    }

    private void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(ConfigurationModel.class, ConfigurationModelHandler::makeInstance);
        defaultProcessor.addHandler(PropertyModel.class, VariableModelHandler::makeInstance);
        defaultProcessor.addHandler(ContextNameModel.class, ContextNameModelHandler::makeInstance);
        defaultProcessor.addHandler(ImportModel.class, ImportModelHandler::makeInstance);
        defaultProcessor.addHandler(DefineModel.class, DefineModelHandler::makeInstance);
        defaultProcessor.addHandler(InsertFromJNDIModel.class, TylerInsertFromJNDIModelHandler::makeInstance);
        defaultProcessor.addHandler(StatusListenerModel.class, StatusListenerModelHandler::makeInstance);
        defaultProcessor.addHandler(ShutdownHookModel.class, ShutdownHookModelHandler::makeInstance);
        defaultProcessor.addHandler(TimestampModel.class, TimestampModelHandler::makeInstance);
        defaultProcessor.addHandler(PropertiesConfiguratorModel.class, TylerPropertiesConfiguratorModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderModel.class, AppenderModelHandler::makeInstance);
        defaultProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
        defaultProcessor.addHandler(LoggerModel.class, LoggerModelHandler::makeInstance);
        defaultProcessor.addHandler(RootLoggerModel.class, RootLoggerModelHandler::makeInstance);
        defaultProcessor.addHandler(LevelModel.class, LevelModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderRefModel.class, AppenderRefModelHandler::makeInstance);
        defaultProcessor.addHandler(IncludeModel.class, TylerIncludeModelHandler::makeInstance);
        defaultProcessor.addHandler(LoggerContextListenerModel.class, LoggerContextListenerModelHandler::makeInstance);
        defaultProcessor.addHandler(SequenceNumberGeneratorModel.class, SequenceNumberGeneratorModelHandler::makeInstance);
        defaultProcessor.addHandler(IfModel.class, IfModelHandler::makeInstance);
        defaultProcessor.addHandler(ThenModel.class, ThenModelHandler::makeInstance);
        defaultProcessor.addHandler(ElseModel.class, ElseModelHandler::makeInstance);
    }
}

