/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.StringUtil;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.ClassUtil;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;

public class AppenderModelHandler
extends ModelHandlerBase {
    String appenderVariableName;
    ImplicitModelHandlerData implicitModelHandlerData;
    private boolean skipped = false;
    boolean inError = false;

    public AppenderModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new AppenderModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        AppenderModel appenderModel = (AppenderModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String appenderName = tmic.subst(appenderModel.getName());
        String originalClassName = appenderModel.getClassName();
        String className = mic.getImport(originalClassName);
        this.appenderVariableName = VariableNameUtil.appenderNameToVariableName(appenderName);
        MethodSpec.Builder methodSpec = this.addJavaStatementForAppenderInitialization(tmic, appenderName, className);
        try {
            Class<?> appenderClass = Class.forName(className);
            this.implicitModelHandlerData = new ImplicitModelHandlerData(appenderClass, this.appenderVariableName, methodSpec);
            mic.pushObject((Object)this.implicitModelHandlerData);
        }
        catch (ClassNotFoundException e) {
            this.addError("Could not find class", e);
            this.inError = true;
        }
    }

    MethodSpec.Builder addJavaStatementForAppenderInitialization(TylerModelInterpretationContext tmic, String appenderName, String fullyQualifiedAppenderClassName) {
        ClassName desiredAppenderCN = ClassName.get((String)ClassUtil.extractPackageName(fullyQualifiedAppenderClassName), (String)ClassUtil.extractSimpleClassName(fullyQualifiedAppenderClassName), (String[])new String[0]);
        String fistLetterCapitalizedAppenderName = StringUtil.capitalizeFirstLetter((String)appenderName);
        String methodName = "setupAppender" + fistLetterCapitalizedAppenderName;
        tmic.configureMethodSpecBuilder.addStatement("$T $N = $N()", new Object[]{Appender.class, this.appenderVariableName, methodName});
        MethodSpec.Builder appenderSetupMethodSpec = MethodSpec.methodBuilder((String)methodName).returns(Appender.class).addStatement("$1T $2N = new $1T()", new Object[]{desiredAppenderCN, this.appenderVariableName}).addStatement(this.appenderVariableName + ".setContext($N)", new Object[]{tmic.getContextFieldSpec()}).addStatement(this.appenderVariableName + ".setName($S)", new Object[]{appenderName});
        return appenderSetupMethodSpec;
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addWarn("The object at the of the stack is not the ImplicitModelHandlerData pushed earlier.");
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.popObject();
            MethodSpec.Builder appenderMethodBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            appenderMethodBuilder.addCode("\n", new Object[0]);
            appenderMethodBuilder.addStatement("$N.start()", new Object[]{this.appenderVariableName});
            appenderMethodBuilder.addStatement("return $N", new Object[]{this.appenderVariableName});
            MethodSpec appenderMethodSpec = appenderMethodBuilder.build();
            tmic.tylerConfiguratorTSB.addMethod(appenderMethodSpec);
        }
    }
}

