/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.tyler.base.ModelToJava;
import ch.qos.logback.tyler.base.OutputComparator;
import ch.qos.logback.tyler.base.TylerTestContants;
import ch.qos.logback.tyler.base.antlr4.SyntaxVerifier;
import ch.qos.logback.tyler.base.antlr4.TylerAntlr4ErrorListener;
import ch.qos.logback.tyler.base.helper.FileHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TylerRegressionTest {
    ContextBase context = new ContextBase();
    SyntaxVerifier syntaxVerifier = new SyntaxVerifier();
    ModelToJava m2j = new ModelToJava((Context)this.context);
    OutputComparator outputComparator = new OutputComparator();

    @BeforeEach
    public void setUp() {
    }

    @Test
    void smoke() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "smoke.xml", TylerTestContants.INPUT_PREFIX + "smoke_witness.java", false);
    }

    @Test
    void levelTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "level.xml", TylerTestContants.INPUT_PREFIX + "level_witness.java", false);
    }

    @Test
    void sequenceGeneratorTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "sequenceGenerator.xml", TylerTestContants.INPUT_PREFIX + "sequenceGenerator_witness.java", false);
    }

    @Test
    void contextListenerTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "contextListener.xml", TylerTestContants.INPUT_PREFIX + "contextListener_witness.java", false);
    }

    @Test
    void scanTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "scan.xml", TylerTestContants.INPUT_PREFIX + "scan_witness.java", false);
    }

    @Test
    void defineTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "define.xml", TylerTestContants.INPUT_PREFIX + "define_witness.java", false);
    }

    @Test
    void defineBadFQCNTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "defineBadFQCN.xml", TylerTestContants.INPUT_PREFIX + "defineBadFQCNTest_witness.java", false);
    }

    @Test
    void conditionalTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "conditional.xml", TylerTestContants.INPUT_PREFIX + "conditional_witness.java", false);
    }

    @Test
    void asyncTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "async.xml", TylerTestContants.INPUT_PREFIX + "async_witness.java", false);
    }

    @Test
    void timestampTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "timestamp.xml", TylerTestContants.INPUT_PREFIX + "timestamp_witness.java", false);
    }

    @Test
    void propertiesConfiguratorTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "propertiesConfigurator.xml", TylerTestContants.INPUT_PREFIX + "propertiesConfigurator_witness.java", false);
    }

    @Test
    void propertiesConfiguratorWithScanTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "propertiesConfiguratorWithScan.xml", TylerTestContants.INPUT_PREFIX + "propertiesConfiguratorWithScan_witness.java", false);
    }

    @Test
    void topIncludingTest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "topIncluding.xml", TylerTestContants.INPUT_PREFIX + "topIncluding_witness.java", false);
    }

    @Test
    void insertFromJNDITest() throws JoranException, IOException {
        this.verify(TylerTestContants.INPUT_PREFIX + "insertFromJNDI.xml", TylerTestContants.INPUT_PREFIX + "insertFromJNDI_witness.java", false);
    }

    void verify(String path2XMLFile, String path2WitnessFile, boolean dumpResult) throws JoranException, IOException {
        List<String> lines = FileHelper.readFile(path2XMLFile);
        List<String> witnessLines = FileHelper.readFile(path2WitnessFile);
        StringBuffer buf = new StringBuffer();
        lines.forEach(l -> buf.append((String)l).append("\n"));
        Model model = this.m2j.extractModel(buf.toString());
        String result = this.m2j.toJava(model);
        String[] resultArray = result.split("\n");
        ArrayList<String> resultList = new ArrayList<String>(List.of(resultArray));
        List statusList = this.m2j.statusToStringList();
        resultList.addAll(statusList);
        resultList.forEach(System.out::println);
        Assertions.assertTrue((boolean)this.outputComparator.checkForEquality(witnessLines, resultList));
        TylerAntlr4ErrorListener errorListener = this.syntaxVerifier.verify(result);
        Assertions.assertEquals((int)0, (int)errorListener.getSyntaxErrorCount(), (String)errorListener.getErrorMessages().toString());
    }
}

