/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.util.StatusPrinter2;
import ch.qos.logback.tyler.base.ModelToJava;
import ch.qos.logback.tyler.base.antlr4.SyntaxVerifier;
import ch.qos.logback.tyler.base.antlr4.TylerAntlr4ErrorListener;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TylerTest {
    ContextBase context = new ContextBase();
    SyntaxVerifier syntaxVerifier = new SyntaxVerifier();
    StatusPrinter2 statusPrinter2 = new StatusPrinter2();

    @Test
    void smoke() throws JoranException, IOException {
        ModelToJava m2j = new ModelToJava((Context)this.context);
        String input = "<configuration xdebug=\"true\">\n  <import class=\"ch.qos.logback.classic.encoder.PatternLayoutEncoder\"/>\n  <import class=\"ch.qos.logback.core.ConsoleAppender\"/>\n  <import class=\"ch.qos.logback.core.rolling.RollingFileAppender\"/>\n  <import class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\"/>\n  <import class=\"ch.qos.logback.core.status.OnConsoleStatusListener\"/>\n\n  <shutdownHook/>\n  <statusListener class=\"OnConsoleStatusListener\">\n     <prefix>moo</prefix>\n  </statusListener>\n\n  <property name=\"USER_HOME\" value=\"/home/alice\"/>\n\n  <contextName>${APPNAME}</contextName>\n\n  <appender name=\"RFILE\" class=\"RollingFileAppender\">\n     <file>${USER_HOME}/logFile.log</file>\n     <rollingPolicy class=\"TimeBasedRollingPolicy\">\n       <fileNamePattern>logFile.%d{yyyy-MM-dd}.log</fileNamePattern>\n       <maxHistory>30</maxHistory>\n       <totalSizeCap>3GB</totalSizeCap>\n     </rollingPolicy>\n     <encoder class=\"PatternLayoutEncoder\">\n       <pattern>%-4relative [%thread] %-5level %logger{35} -%kvp- %msg%n</pattern>\n     </encoder>\n  </appender>\n\n  <logger name=\"com.foo.Bar\" level=\"DEBUG\">\n     <appender-ref ref=\"RFILE\"/>\n  </logger>\n\n   <root level=\"DEBUG\">\n     <appender-ref ref=\"toto\"/>\n     <appender-ref ref=\"RFILE\"/>\n  </root>\n</configuration>\n";
        Model model = m2j.extractModel(input);
        String result = m2j.toJava(model);
        TylerAntlr4ErrorListener errorListener = this.syntaxVerifier.verify(result);
        this.statusPrinter2.print((Context)this.context);
        System.out.println("----------------");
        System.out.println(result);
        System.out.println("----------------");
        Assertions.assertEquals((int)0, (int)errorListener.getSyntaxErrorCount(), (String)errorListener.getErrorMessages().toString());
    }

    @Test
    void example() throws IOException, JoranException {
        String xmlInput = "<configuration debug=\"true\">\n  <import class=\"ch.qos.logback.classic.encoder.PatternLayoutEncoder\"/>\n  <import class=\"ch.qos.logback.core.ConsoleAppender\"/>\n  <import class=\"ch.qos.logback.core.rolling.RollingFileAppender\"/>\n  <import class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\"/>\n\n  <property name=\"APP_NAME\" value=\"myApp\"/>\n\n  <contextName>${APP_NAME}</contextName>\n\n  <appender class=\"ch.qos.logback.core.FileAppender\" name=\"RFILE\">\n     <file>toto.log</file>\n     <append>true</append>\n     <immediateFlush>true</immediateFlush>\n     <encoder>\n       <pattern>%-4relative [%thread] %-5level %logger{35} -%kvp- %msg%n</pattern>\n     </encoder>\n\n  </appender>\n\n\n   <root level=\"DEBUG\">\n     <appender-ref ref=\"RFILE\"/>\n  </root>\n</configuration>\n";
        ModelToJava m2j = new ModelToJava((Context)this.context);
        Model model = m2j.extractModel(xmlInput);
        String result = m2j.toJava(model);
        System.out.println("----------------");
        System.out.println(result);
        System.out.println("----------------");
        this.statusPrinter2.print((Context)this.context);
    }
}

