/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import ch.qos.logback.tyler.base.IncludeTylerConfigurator;
import ch.qos.logback.tyler.base.generated.PropertiesConfiguratorInclusionTylerConfigurator;
import ch.qos.logback.tyler.base.generated.PropertiesConfiguratorInclusionWithScanTylerConfigurator;
import ch.qos.logback.tyler.base.generated.SmokeTylerConfigurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.spi.MDCAdapter;

@Disabled
public class VariousTylerConfiguratorTest {
    LoggerContext loggerContext = new LoggerContext();
    MDCAdapter mdcAdapter = new LogbackMDCAdapter();
    StatusPrinter statusPrinter = new StatusPrinter();
    StatusChecker statusChecker = new StatusChecker((Context)this.loggerContext);

    @BeforeEach
    public void setUp() {
        this.loggerContext.setMDCAdapter(this.mdcAdapter);
    }

    @Test
    @Disabled
    public void smoke() {
        long start = System.currentTimeMillis();
        SmokeTylerConfigurator tc = new SmokeTylerConfigurator();
        tc.configure(this.loggerContext);
        long end = System.currentTimeMillis();
        long diff = end - start;
        System.out.println("time " + diff);
        Logger rootLogger = this.loggerContext.getLogger("ROOT");
        RollingFileAppender rollingFileAppender = (RollingFileAppender)rootLogger.getAppender("RFILE");
        TimeBasedRollingPolicy timeBasedRollingPolicy = (TimeBasedRollingPolicy)rollingFileAppender.getRollingPolicy();
        TimeBasedFileNamingAndTriggeringPolicy tbfnatp = timeBasedRollingPolicy.getTimeBasedFileNamingAndTriggeringPolicy();
        Logger logger = this.loggerContext.getLogger(this.getClass());
        long now = System.currentTimeMillis();
        long MILLIS_IN_DAY = 86400000L;
        for (int i = 0; i < 10; ++i) {
            tbfnatp.setCurrentTime(now + (long)i * MILLIS_IN_DAY);
            logger.info("hello world " + i);
            this.delay(1000);
        }
        Assertions.assertNotNull((Object)rollingFileAppender);
        Assertions.assertTrue((boolean)rollingFileAppender.isStarted());
    }

    private void delay(int duration) {
        try {
            Thread.currentThread();
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void joran() throws JoranException {
        long start = System.currentTimeMillis();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure("src/test/resources/logback-two.xml");
        long end = System.currentTimeMillis();
        long diff = end - start;
        System.out.println("time " + diff);
    }

    @Test
    public void propertiesConfiguratorInclusionTest() throws InterruptedException {
        PropertiesConfiguratorInclusionTylerConfigurator tc = new PropertiesConfiguratorInclusionTylerConfigurator();
        tc.configure(this.loggerContext);
        Logger bazingaLogger = this.loggerContext.getLogger("com.bazinga");
        Assertions.assertEquals((Object)Level.INFO, (Object)bazingaLogger.getLevel());
    }

    @Test
    public void propertiesConfiguratorInclusionWithScanTest() throws InterruptedException {
        PropertiesConfiguratorInclusionWithScanTylerConfigurator tc = new PropertiesConfiguratorInclusionWithScanTylerConfigurator();
        tc.configure(this.loggerContext);
        Logger bazingaLogger = this.loggerContext.getLogger("com.bazinga");
        Assertions.assertEquals((Object)Level.INFO, (Object)bazingaLogger.getLevel());
        this.statusChecker.assertIsWarningOrErrorFree();
        this.statusChecker.assertContainsMatch("Adding \\[file:/C:/home/ceki/logback-tyler/tyler-base/src/test/input/included1.properties\\] to configuration watch list.");
        this.statusChecker.assertContainsMatch("Registering a new ReconfigureOnChangeTask ReconfigureOnChangeTask");
        this.statusChecker.assertContainsMatch("Will scan for changes in");
        this.statusChecker.assertContainsMatch("Setting ReconfigureOnChangeTask scanning period to 30 seconds");
    }

    @Test
    public void includeXMLTest() throws InterruptedException {
        IncludeTylerConfigurator tc = new IncludeTylerConfigurator();
        tc.configure(this.loggerContext);
        Logger bazingaLogger = this.loggerContext.getLogger("com.bazinga");
        Assertions.assertEquals((Object)Level.INFO, (Object)bazingaLogger.getLevel());
    }
}

